<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Admin {
	public function __construct( $license ) {

		add_action( 'admin_enqueue_scripts', array( $this, 'license_script' ) );
		add_filter( 'modula_admin_page_tabs', array( $this, 'add_license_tab' ) );
		add_action( 'modula_admin_tab_licenses', array( $this, 'show_licenses_tab' ) );
		add_action( 'admin_footer', array( $this, 'add_css_translation' ) );
		add_action( 'admin_footer', array( $this, 'add_menu_styles' ) );

		if ( $license ) {
			// Remove Albums upsell metabox.
			add_action( 'do_meta_boxes', array( $this, 'remove_albums_upsell_metabox' ), 16, 1 );

			// Enqueue block assets.
			add_action( 'modula_block_style', array( $this, 'enqueue_modula_block_styles' ) );
			add_action( 'modula_block_scripts', array( $this, 'enqueue_modula_block_scripts' ) );

			// Run bulk editor functionality
			new Modula_Pro_Bulk_Editor();
		}
	}

	public function add_css_translation() {
		global $pagenow, $typenow;

		if ( 'post.php' === $pagenow && 'modula-gallery' === $typenow ) {
			// Injectăm CSS-ul în footer
			echo '<style>
					:root {
						--modula-hidden-text: "' . esc_html__( 'Hidden', 'modula-pro' ) . '";
					}
				</style>';
		}
	}

	public function license_script() {
		global $id, $post;

		// Get current screen.
		$screen = get_current_screen();

		// Add license protection scrip
		// Previous was inline
		if ( 'modula-gallery_page_modula' === $screen->base ) {
			wp_enqueue_script( 'modula-license-protection_activation', MODULA_PRO_URL . 'assets/js/misc/license-protection_activation.js', array( 'jquery' ), MODULA_PRO_VERSION, true );
			wp_localize_script(
				'modula-license-protection_activation',
				'modulaLicense',
				array(
					'nonce'               => wp_create_nonce( 'modula_license_save' ),
					'ajaxURL'             => admin_url( 'admin-ajax.php' ),
					'activatingLicense'   => esc_html__( 'Activating license. Please wait...', 'modula-pro' ),
					'deactivatingLicense' => esc_html__( 'Deactivating license. Please wait...', 'modula-pro' ),
					'missingEmail'        => esc_html__( 'Please enter the email address used to purchase the license.', 'modula-pro' ),
					'retrievingData'      => esc_html__( 'Retrieving data...', 'modula-pro' ),
					'sentEmail'           => esc_html__( 'An email containing the license key has been sent to the email address above.', 'modula-pro' ),
					'responseError'       => esc_html__( 'There was a problem retrieving the data. Please try again or use alternative server.', 'modula-pro' ),
				)
			);
		}

		wp_enqueue_style( 'modula-pro-style', MODULA_PRO_URL . 'assets/js/misc/wp-modula-pro.css', array(), MODULA_PRO_VERSION );
	}


	public function add_license_tab( $tabs ) {

		$tabs['licenses'] = array(
			'label'    => esc_html__( 'Licenses', 'modula-pro' ),
			'priority' => -1,
		);

		return $tabs;
	}

	public function show_licenses_tab() {
		include 'tabs/license.php';
	}

	public function remove_albums_upsell_metabox() {
		remove_meta_box( 'modula-albums-upsell', 'modula-gallery', 'normal' );
	}

	public function enqueue_modula_block_styles() {
		wp_enqueue_style( 'modula-pro-effects', MODULA_PRO_URL . 'assets/js/misc/effects.css', array(), MODULA_PRO_VERSION );

		wp_enqueue_style( 'modula-pro-bnb', MODULA_PRO_URL . 'assets/js/misc/modula-pro.css', array(), MODULA_PRO_VERSION );
	}

	public function enqueue_modula_block_scripts() {
		$screen = get_current_screen();
		if ( 'post' !== $screen->base && 'page' !== $screen->base && 'widgets' !== $screen->base ) {
			return;
		}
		wp_enqueue_script( 'modula-pro-gutenberg', MODULA_PRO_URL . 'assets/js/misc/modula-pro.js', array( 'jquery' ), MODULA_PRO_VERSION, true );
		wp_enqueue_script( 'modula-pro', MODULA_PRO_URL . 'assets/js/misc/modula-pro.js', array( 'jquery' ), MODULA_PRO_VERSION, true );
		wp_enqueue_script( 'modula-pro-tilt', MODULA_PRO_URL . 'assets/js/misc/modula-pro-tilt.js', array( 'jquery' ), MODULA_PRO_VERSION, true );
	}

	public function add_menu_styles() {
		if ( Modula_Pro_Helper::check_plugin_is_active( 'modula-defaults' ) ) {
			return;
		}
		?>
		<style>
			#menu-posts-modula-gallery .wp-submenu li a[href$="modula-gallery"],
			#menu-posts-modula-gallery .wp-submenu li a[href$="modula-album"] {
				border-bottom: 1px solid hsla(0, 0%, 100%, .2);
			}

			#menu-posts-modula-gallery .wp-submenu li a[href$="modula-gallery"]:first-of-type {
				border-bottom: none;
			}
		</style>
		<?php
	}
}
