<?php

class Modula_Pro_Bulk_Editor {
	/**
	 * Constructor
	 *
	 * @since 2.8.0
	 */
	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_react_apps' ) );
		add_action( 'modula_gallery_media_button', array( $this, 'add_bulk_editor_button' ), 10, 2 );
		// Add the bulk editor button to the gallery list.
		add_filter( 'post_row_actions', array( $this, 'bulk_edit_images' ), 10, 2 );
	}

	/**
	 * Add the bulk editor button
	 *
	 * @since 2.8.0
	 */
	public function add_bulk_editor_button() {
		echo '<div id="modula-pro-bulk-editor" data-gallery-id="' . esc_attr( get_the_ID() ) . '"><a href="#" class="button modula-pro-bulk-editor-button">' . esc_html__( 'Bulk Editor', 'modula-pro' ) . '</a></div>';
	}

	/**
	 * Enqueue the react apps
	 *
	 * @since 2.8.0
	 */
	public function enqueue_react_apps() {
		$current_screen = get_current_screen();

		if ( 'modula-gallery' !== $current_screen->id && 'edit-modula-gallery' !== $current_screen->id ) {
			return;
		}

		$asset_file = require MODULA_PRO_REACT_APPS_PATH . '/bulk-editor.asset.php';
		$enqueue    = array(
			'handle'       => 'modula-pro-bulk-editor',
			'dependencies' => $asset_file['dependencies'],
			'version'      => $asset_file['version'],
			'script'       => MODULA_PRO_REACT_APPS_URL . '/bulk-editor.js',
			'style'        => MODULA_PRO_REACT_APPS_URL . '/bulk-editor.css',
		);

		wp_enqueue_script(
			$enqueue['handle'],
			$enqueue['script'],
			$enqueue['dependencies'],
			$enqueue['version'],
			true
		);

		wp_enqueue_style(
			$enqueue['handle'],
			$enqueue['style'],
			array( 'wp-components' ),
			$enqueue['version']
		);
	}

	/**
	 * Add the link to action list for post_row_actions
	 *
	 * @param  array    $actions  The actions array.
	 * @param  WP_Post  $post     The post object.
	 *
	 * @since 2.8.2
	 */
	public function bulk_edit_images( $actions, $post ) {
		if ( 'modula-gallery' !== get_post_type( $post ) ) {
			return $actions;
		}

		$actions['bulk_editor'] = '<a href="#" class="modula-pro-bulk-editor-button" data-gallery-id="' . absint( $post->ID ) . '" title="' . esc_attr__( 'Bulk Editor', 'modula-pro' ) . '">' . esc_html__( 'Bulk Editor', 'modula-best-grid-gallery' ) . '</a>';

		return $actions;
	}
}
