<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Debug {

	public function __construct() {
		add_filter( 'modula_debug_information', array( $this, 'debug_information' ) );
	}

	public function debug_information( $info ) {
		$licenses_status = get_option( 'modula_pro_license_status', false );
		$date_format     = get_option( 'date_format' );
		$license_expire  = date( $date_format, strtotime( $licenses_status->expires ) );
		$alt_serv        = get_option( 'modula_pro_alernative_server' );
		$troubleshoot    = get_option( 'modula_troubleshooting_option' );

		$info['pro_version'] = array(
			'label' => __( 'PRO Version', 'modula-pro' ),
			'value' => MODULA_PRO_VERSION,
			'debug' => esc_html( 'PRO version ' . MODULA_PRO_VERSION ),
		);

		$info['license'] = array(
			'label' => __( 'License', 'modula-pro' ),
			'value' => ( ! $licenses_status || 'valid' !== $licenses_status->license ) ? __( 'License inactive', 'modula-pro' ) : sprintf(
				// translators: %s: license expiration date
				__( 'License active until %s', 'modula-pro' ),
				$license_expire
			),
			'debug' => ( ! $licenses_status || 'valid' !== $licenses_status->license ) ? esc_html( 'License inactive' ) : esc_html( 'License active  ' . $license_expire ),
		);

		$info['alternative_server'] = array(
			'label' => __( 'Alternative license server', 'modula-pro' ),
			'value' => ( isset( $alt_serv ) && 'true' === $alt_serv ) ? __( 'Using alternative license server', 'modula-pro' ) : __( 'Using regular license server', 'modula-pro' ),
			'debug' => ( isset( $alt_serv ) && 'true' === $alt_serv ) ? 'Using alternative license server' : 'Using regular license server',
		);

		$info['troubleshoot_modula_link'] = array(
			'label' => __( 'Modula Link everywhere', 'modula-pro' ),
			'value' => ( isset( $troubleshoot['link_shortcode'] ) && '1' === $troubleshoot['link_shortcode'] ) ? __( 'Enabled', 'modula-pro' ) : __( 'Disabled', 'modula-pro' ),
			'debug' => ( isset( $troubleshoot['link_shortcode'] ) && '1' === $troubleshoot['link_shortcode'] ) ? 'Enabled' : 'Disabled',
		);

		return $info;
	}
}
