<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Filters {
	public function __construct() {
		add_filter( 'modula_gallery_settings', array( $this, 'modula_pro_config' ), 10, 2 );
		add_filter( 'modula_shortcode_item_data', array( $this, 'modula_pro_extra_item_data' ), 16, 3 );
		add_filter( 'modula_gallery_template_data', array( $this, 'filter_class_helper' ), 20, 1 );
	}

	public function modula_pro_config( $js_config, $settings ) {
		$js_config['lightbox'] = $settings['lightbox'];

		if ( apply_filters( 'modula_disable_lightboxes', true ) && ! in_array( $settings['lightbox'], array( 'no-link', 'direct', 'attachment-page', 'external-url' ), true ) ) {
			$js_config['lightbox'] = 'fancybox';
		}

		if ( isset( $settings['filterClick'] ) ) {
			$js_config['filterClick'] = esc_attr( $settings['filterClick'] );
		}

		if ( isset( $settings['dropdownFilters'] ) ) {
			$js_config['dropdownFilters'] = esc_attr( $settings['dropdownFilters'] );

			if ( wp_is_mobile() && isset( $settings['enableMobileDropdownFilters'] ) && 1 === $settings['enableMobileDropdownFilters'] ) {
				$js_config['dropdownFilters'] = '1';
			}
		}

		$js_config['defaultActiveFilter'] = ( isset( $settings['defaultActiveFilter'] ) ) ? esc_attr( sanitize_title( $settings['defaultActiveFilter'] ) ) : false;
		$js_config['initLightbox']        = 'modula_pro_init_lightbox';

		$js_config['haveFilters'] = 0;
		if ( isset( $settings['filters'] ) && 'bnb' !== $settings['type'] ) {
			$filters = Modula_Pro_Helper::remove_empty_items( $settings['filters'] );

			if ( is_array( $filters ) && ! empty( $filters ) ) {
				$js_config['haveFilters'] = 1;
			}
		}

		// Copy caption on double tap but only on mobile - wp_is_mobile()
		if ( isset( $settings['mobile_caption_copy'] ) && 1 === absint( $settings['mobile_caption_copy'] ) && wp_is_mobile() ) {
			$js_config['copyCaptionMobile'] = 1;
		}

		if ( isset( $settings['open_Lightbox_on'] ) ) {
			$js_config['lightbox_devices'] = sanitize_text_field( $settings['open_Lightbox_on'] );
		}

		if ( isset( $settings['doubleClick'] ) && 1 === absint( $settings['doubleClick'] ) ) {
			$js_config['mobileDoubleClick'] = 1;
		}

		return $js_config;
	}

	public function modula_pro_extra_item_data( $item_data, $image, $settings ) {
		// ... (rest of the method content)
		return $item_data;
	}

	public function filter_class_helper( $template_data ) {
		// ... (method content)
		return $template_data;
	}
}
