<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Gallery_Upgrade {
	public function __construct() {
		add_filter( 'modula_gallery_settings', array( $this, 'pro_config' ), 10, 2 );
		add_action( 'modula_shortcode_before_items', array( $this, 'pro_output_filters' ), 15 );
		add_action( 'modula_shortcode_after_items', array( $this, 'pro_output_filters' ), 15 );
		add_filter( 'modula_gallery_template_data', array( $this, 'pro_extra_modula_section_classes' ) );
		add_filter( 'modula_shortcode_item_data', array( $this, 'pro_add_filters' ), 30, 3 );

		add_filter( 'modula_gallery_images', array( $this, 'pro_max_count' ), 10, 2 );
		add_filter( 'modula_pagination_links', array( $this, 'pro_max_count' ), 10, 2 );
		add_action( 'modula_shortcode_after_items', array( $this, 'output_removed_items' ), 10, 3 );

		add_filter( 'modula_effects_with_title', array( $this, 'aditional_pro_effects' ) );
		add_filter( 'modula_effects_with_description', array( $this, 'aditional_pro_effects' ) );
		add_filter( 'modula_effects_with_social', array( $this, 'aditional_pro_effects' ) );

		add_filter( 'modula_shortcode_css', array( $this, 'generate_new_css' ), 10, 3 );
	}

	public function pro_config( $js_config, $settings ) {
		$js_config['lightbox'] = $settings['lightbox'];

		if ( apply_filters( 'modula_disable_lightboxes', true ) && ! in_array( $settings['lightbox'], array( 'no-link', 'direct', 'attachment-page', 'external-url' ), true ) ) {
			$js_config['lightbox'] = 'fancybox';
		}

		if ( isset( $settings['filterClick'] ) ) {
			$js_config['filterClick'] = esc_attr( $settings['filterClick'] );
		}

		if ( isset( $settings['dropdownFilters'] ) ) {
			$js_config['dropdownFilters'] = esc_attr( $settings['dropdownFilters'] );

			if ( wp_is_mobile() && isset( $settings['enableMobileDropdownFilters'] ) && 1 === $settings['enableMobileDropdownFilters'] ) {
				$js_config['dropdownFilters'] = '1';
			}
		}

		$js_config['defaultActiveFilter'] = ( isset( $settings['defaultActiveFilter'] ) ) ? esc_attr( sanitize_title( $settings['defaultActiveFilter'] ) ) : false;
		$js_config['initLightbox']        = 'modula_pro_init_lightbox';

		$js_config['haveFilters'] = 0;
		if ( isset( $settings['filters'] ) && 'bnb' !== $settings['type'] ) {
			$filters = Modula_Pro_Helper::remove_empty_items( $settings['filters'] );

			if ( is_array( $filters ) && ! empty( $filters ) ) {
				$js_config['haveFilters'] = 1;
			}
		}

		// Copy caption on double tap but only on mobile - wp_is_mobile()
		if ( isset( $settings['mobile_caption_copy'] ) && 1 === absint( $settings['mobile_caption_copy'] ) && wp_is_mobile() ) {
			$js_config['copyCaptionMobile'] = 1;
		}

		if ( isset( $settings['open_Lightbox_on'] ) ) {
			$js_config['lightbox_devices'] = sanitize_text_field( $settings['open_Lightbox_on'] );
		}

		if ( isset( $settings['doubleClick'] ) && 1 === absint( $settings['doubleClick'] ) ) {
			$js_config['mobileDoubleClick'] = 1;
		}

		return $js_config;
	}

	public function pro_output_filters( $settings ) {

		if ( ! isset( $settings['filters'] ) ) {
			return '';
		}

		$filters = Modula_Pro_Helper::remove_empty_items( $settings['filters'] );

		if ( ! is_array( $filters ) ) {
			return;
		}

		if ( empty( $filters ) ) {
			return;
		}

		$before_items = array( 'top', 'top_bottom', 'left', 'left_right' );
		$after_items  = array( 'bottom', 'top_bottom', 'right', 'left_right' );
		$horizontal   = array( 'top', 'bottom', 'top_bottom' );

		$current_filter = isset( $settings['defaultActiveFilter'] ) ? $settings['defaultActiveFilter'] : 'all';
		if ( isset( $_GET['jtg-filter'] ) ) {
			$current_filter = sanitize_text_field( wp_unslash( $_GET['jtg-filter'] ) );
		}
		$current_filter = sanitize_title( $current_filter );
		$filter_url     = $settings['filterClick'] ? wp_nonce_url( add_query_arg( 'jtg-filter', 'all' ), 'modula_filter_nonce' ) : '#';

		$hide_all_filter = $settings['hideAllFilter'];

		$filter_position = isset( $settings['filterPositioning'] ) ? $settings['filterPositioning'] : '';

		$extra_classes  = isset( $settings['filterStyle'] ) ? 'styled-menu menu--' . $settings['filterStyle'] : '';
		$extra_classes .= in_array( $filter_position, $horizontal, true )
			? ' horizontal-filters'
			: ' vertical-filters';

		if ( 'left' === $filter_position ) {
			$extra_classes .= ' left-vertical';
		}

		if ( 'right' === $filter_position ) {
			$extra_classes .= ' right-vertical';
		}

		if ( 'left_right' === $filter_position ) {
			$extra_classes .= ' both-vertical';
		}

		$filter_by_text = '';
		if ( isset( $settings['enableCollapsibleFilters'] ) && 1 === absint( $settings['enableCollapsibleFilters'] ) && isset( $settings['collapsibleActionText'] ) && ( ! isset( $settings['dropdownFilters'] ) || 1 !== absint( $settings['dropdownFilters'] ) ) && ( ! isset( $settings['enableMobileDropdownFilters'] ) || 1 !== absint( $settings['enableMobileDropdownFilters'] ) ) ) {
			$filter_by_text = $settings['collapsibleActionText'];
		}

		$filter_by_wrapper_style = '';
		if ( isset( $settings['enableCollapsibleFilters'] ) && 1 === absint( $settings['enableCollapsibleFilters'] ) && ( ! isset( $settings['dropdownFilters'] ) || 1 !== absint( $settings['dropdownFilters'] ) ) && ( ! isset( $settings['enableMobileDropdownFilters'] ) || 1 !== absint( $settings['enableMobileDropdownFilters'] ) ) ) {
			$filter_by_wrapper_style = 'display:none;';
		}

		if ( doing_filter( 'modula_shortcode_before_items' ) && ! in_array( $filter_position, $before_items, true ) ) {
			return false;
		}

		if ( doing_filter( 'modula_shortcode_after_items' ) && ! in_array( $filter_position, $after_items, true ) ) {
			return false;
		}

		if ( isset( $settings['enableCollapsibleFilters'] ) && 1 === absint( $settings['enableCollapsibleFilters'] ) && ( ! isset( $settings['dropdownFilters'] ) || 1 !== absint( $settings['dropdownFilters'] ) ) && ( ! isset( $settings['enableMobileDropdownFilters'] ) || 1 !== absint( $settings['enableMobileDropdownFilters'] ) ) ) {
			echo '<div class="filter-by-wrapper"><span>' . esc_html( $filter_by_text ) . '</span></div>';
		}

		// If enabled, this overwrites the filters mode in mobile view
		if ( wp_is_mobile() && (
		( isset( $settings['enableMobileDropdownFilters'] ) && 1 === absint( $settings['enableMobileDropdownFilters'] ) ) ||
		( isset( $settings['dropdownFilters'] ) && 1 === absint( $settings['dropdownFilters'] ) )
		) ) {
			echo "<select class='filters " . esc_attr( $extra_classes ) . "' style='" . esc_attr( $filter_by_wrapper_style ) . "'>";

			if ( ! isset( $hide_all_filter ) || 1 !== absint( $hide_all_filter ) ) {
				echo '<option class="modula_menu__item ' . ( 'All' === $current_filter ? 'modula_menu__item--current' : '' ) . '" value="all"><a  href="' . esc_url( $filter_url ) . '" class="' . ( 'all' === $current_filter ? 'selected' : '' ) . ' modula_modula_menu__link ">' . esc_html( $settings['allFilterLabel'] ) . '</a></option>';
			}

			foreach ( $filters as $filter ) {
				$comma       = '&#44';
				$filter      = str_replace( $comma, ',', $filter );
				$filter_slug = sanitize_title( $filter );
				$filter_url  = $settings['filterClick'] ? '?jtg-filter=' . $filter_slug : '#jtg-filter-' . $filter_slug;
				if ( $filter_slug === $current_filter ) {
					echo '<option selected class="modula_menu__item ' . ( $filter_slug === $current_filter ? 'modula_menu__item--current' : '' ) . '" value="' . esc_attr( urldecode( $filter_slug ) ) . '"><a href="' . esc_url( $filter_url ) . '" class=" modula_menu__link  ' . ( $current_filter === $filter_slug ? 'selected' : '' ) . '">' . esc_html( $filter ) . '</option>';
				} else {
					echo '<option class="modula_menu__item ' . ( $filter_slug === $current_filter ? 'modula_menu__item--current' : '' ) . '" value="' . esc_attr( urldecode( $filter_slug ) ) . '"><a href="' . esc_url( $filter_url ) . '" class=" modula_menu__link  ' . ( $current_filter === $filter_slug ? 'selected' : '' ) . '">' . esc_html( $filter ) . '</option>';
				}
			}

			echo '</select>';

			return;
		}

		if ( ! wp_is_mobile() && isset( $settings['dropdownFilters'] ) && 1 === absint( $settings['dropdownFilters'] ) ) {
			echo "<select class='filters " . esc_attr( $extra_classes ) . "' style='" . esc_attr( $filter_by_wrapper_style ) . "'>";

			if ( ! isset( $hide_all_filter ) || 1 !== absint( $hide_all_filter ) ) {
				echo '<option class="modula_menu__item ' . ( 'All' === $current_filter ? 'modula_menu__item--current' : '' ) . '" value="all"><a  href="' . esc_url( $filter_url ) . '" class="' . ( 'all' === $current_filter ? 'selected' : '' ) . ' modula_modula_menu__link ">' . esc_html( $settings['allFilterLabel'] ) . '</a></option>';
			}

			foreach ( $filters as $filter ) {
				$filter_slug = sanitize_title( $filter );
				$filter_url  = $settings['filterClick'] ? '?jtg-filter=' . $filter_slug : '#jtg-filter-' . $filter_slug;
				if ( $filter_slug === $current_filter ) {
					echo '<option selected class="modula_menu__item ' . ( $filter_slug === $current_filter ? 'modula_menu__item--current' : '' ) . '" value="' . esc_attr( urldecode( $filter_slug ) ) . '"><a href="' . esc_url( $filter_url ) . '" class=" modula_menu__link  ' . ( $current_filter === $filter_slug ? 'selected' : '' ) . '">' . esc_html( $filter ) . '</option>';
				} else {
					echo '<option class="modula_menu__item ' . ( $filter_slug === $current_filter ? 'modula_menu__item--current' : '' ) . '" value="' . esc_attr( urldecode( $filter_slug ) ) . '"><a href="' . esc_url( $filter_url ) . '" class=" modula_menu__link  ' . ( $current_filter === $filter_slug ? 'selected' : '' ) . '">' . esc_html( $filter ) . '</option>';
				}
			}

			echo '</select>';
			return;
		}

		echo "<div class='filters " . esc_attr( $extra_classes ) . "' style='" . esc_attr( $filter_by_wrapper_style ) . "'><ul class='modula_menu__list'>";

		if ( ! isset( $hide_all_filter ) || 1 !== $hide_all_filter ) {
			echo '<li class="modula_menu__item ' . ( 'all' === $current_filter ? 'modula_menu__item--current' : '' ) . '"><a data-filter="all" href="' . esc_url( $filter_url ) . '" class="' . ( 'all' === $current_filter ? 'selected' : '' ) . ' modula_menu__link ">' . esc_html( $settings['allFilterLabel'] ) . '</a>';
		}

		foreach ( $filters as $filter ) {
			$comma       = '&#44';
			$filter      = str_replace( $comma, ',', $filter );
			$filter_slug = sanitize_title( $filter );
			$filter_url  = $settings['filterClick'] ? '?jtg-filter=' . $filter_slug : '#jtg-filter-' . $filter_slug;
			echo '<li class="modula_menu__item ' . ( $filter_slug === $current_filter ? 'modula_menu__item--current' : '' ) . '"><a data-filter="' . esc_attr( urldecode( $filter_slug ) ) . '" href="' . esc_url( $filter_url ) . '" class=" modula_menu__link  ' . ( $current_filter === $filter_slug ? 'selected' : '' ) . '">' . esc_html( $filter ) . '</a></li>';
		}
		echo '</div>';
	}

	public function pro_extra_modula_section_classes( $template_data ) {

		if ( ! isset( $template_data['settings']['filters'] ) || empty( Modula_Pro_Helper::remove_empty_items( $template_data['settings']['filters'] ) ) ) {
			return $template_data;
		}

		$filter_position = isset( $template_data['settings']['filterPositioning'] )
		? $template_data['settings']['filterPositioning']
		: '';
		$horizontal      = array( 'top', 'bottom', 'top_bottom' );
		$extra_classes   = in_array( $filter_position, $horizontal, true ) ? ' horizontal-filters' : ' vertical-filters';

		$template_data['gallery_container']['class'][] = $extra_classes;
		return $template_data;
	}

	public function pro_add_filters( $item_data, $item ) {

		if ( isset( $item['filters'] ) ) {
			$filters                     = explode( ',', $item['filters'] );
			$item_data['item_classes'][] = 'jtg-filter-all';

			foreach ( $filters as $filter ) {
				$comma                       = '&#44';
				$item_data['item_classes'][] = 'jtg-filter-' . esc_attr( urldecode( sanitize_title( str_replace( $comma, ',', $filter ) ) ) );
			}
		}

		return $item_data;
	}

	public function pro_max_count( $images, $settings ) {
		$supported_types = apply_filters( 'modula_supported_types', array( 'creative-gallery', 'custom-grid', 'grid' ) );

		if ( in_array( $settings['type'], $supported_types, true ) ) {

			// Check if is mobile
			if ( wp_is_mobile() ) {
				// Check if is set, else have a backup
				if ( isset( $settings['maxImagesCount_mobile'] ) ) {
					if ( absint( $settings['maxImagesCount_mobile'] ) > 0 ) {
						$images = array_slice( $images, 0, absint( $settings['maxImagesCount_mobile'] ) );
					}
					// Go to backup
				} elseif ( isset( $settings['maxImagesCount'] ) && absint( $settings['maxImagesCount'] ) > 0 ) {
					$images = array_slice( $images, 0, absint( $settings['maxImagesCount'] ) );
				}
			} elseif ( isset( $settings['maxImagesCount'] ) && absint( $settings['maxImagesCount'] ) > 0 ) {
				$images = array_slice( $images, 0, absint( $settings['maxImagesCount'] ) );
			}
		}

		return $images;
	}

	public function output_removed_items( $settings, $item_data, $images ) {

		if ( ! isset( $settings['maxImagesCount'] ) || ( absint( $settings['maxImagesCount'] ) === 0 && ! wp_is_mobile() ) ) {
			return;
		}

		if ( ! isset( $settings['maxImagesCount_mobile'] ) || ( absint( $settings['maxImagesCount_mobile'] ) === 0 && wp_is_mobile() ) ) {
			return;
		}

		if ( ! isset( $settings['showAllOnLightbox'] ) || absint( $settings['showAllOnLightbox'] ) !== 1 ) {
			return;
		}

		$images_ids = wp_list_pluck( $images, 'id' );

		$chuks      = explode( '-', $settings['gallery_id'] );
		$gallery_id = $chuks[1];

		$all_images = get_post_meta( $gallery_id, 'modula-images', true );

		echo '<div class="hidden-items">';
		foreach ( $all_images as $image ) {
			if ( in_array( $image['id'], $images_ids, true ) ) {
				continue;
			}

			$attr = array(
				'class' => array( 'tile-inner', 'modula-hidden-item' ),
			);

			if ( isset( $image['filters'] ) ) {
				$filters = explode( ',', $image['filters'] );
				foreach ( $filters as $filter ) {
					$attr['class'][] = 'jtg-filter-all jtg-filter-' . esc_attr( urldecode( sanitize_title( $filter ) ) );
				}
			}

			$image_full = wp_get_attachment_image_src( $image['id'], 'full' );
			if ( is_array( $image_full ) ) {
				$attr['data-full'] = $image_full[0];
			}
			if ( isset( $item_data['link_attributes']['data-fancybox'] ) ) {
				$attr['data-fancybox'] = $item_data['link_attributes']['data-fancybox'];
			}
			$caption = isset( $image['description'] ) ? $image['description'] : '';

			if ( '' === $caption ) {
				$caption = wp_get_attachment_caption( $image['id'] );
			}

			if ( 'fancybox' === $settings['lightbox'] ) {
				if ( ( isset( $settings['showTitleLightbox'] ) && 1 === absint( $settings['showTitleLightbox'] ) ) && ( isset( $settings['showCaptionLightbox'] ) && 1 === absint( $settings['showCaptionLightbox'] ) ) ) {
					$attr['data-caption'] = esc_attr( '<p>' . $image['title'] . '</p><p>' . $caption . '</p>' );
				} elseif ( ( isset( $settings['showTitleLightbox'] ) && 1 === absint( $settings['showTitleLightbox'] ) ) && ( ! isset( $settings['showCaptionLightbox'] ) || 1 !== absint( $settings['showCaptionLightbox'] ) ) ) {
					$attr['data-caption'] = esc_attr( '<p>' . $image['title'] . '</p>' );
				} elseif ( ( ! isset( $settings['showTitleLightbox'] ) || 1 !== absint( $settings['showTitleLightbox'] ) ) && ( isset( $settings['showCaptionLightbox'] ) && 1 === absint( $settings['showCaptionLightbox'] ) ) ) {
					$attr['data-caption'] = esc_attr( '<p>' . $caption . '</p>' );
				} else {
					$attr['data-caption'] = '';
				}
			} else {
				$attr['data-title'] = $caption;
			}

			//phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo '<a ' . Modula_Helper::generate_attributes( apply_filters( 'modula_hidden_items_data', $attr, $settings, $image ) ) . '></a>';
		}
		echo '</div>';
	}

	public function aditional_pro_effects( $effects ) {

		$effects[] = 'centered-bottom';

		return $effects;
	}

	public function generate_new_css( $css, $gallery_id, $settings ) {

		if ( isset( $settings['hoverColor'] ) ) {
			$css .= "#{$gallery_id} .modula-item .modula-item-overlay, #{$gallery_id} .modula-item.effect-layla, #{$gallery_id}  .modula-item.effect-ruby,#{$gallery_id} .modula-item.effect-bubba,#{$gallery_id} .modula-item.effect-sarah,#{$gallery_id} .modula-item.effect-milo,#{$gallery_id} .modula-item.effect-julia,#{$gallery_id} .modula-item.effect-hera,#{$gallery_id} .modula-item.effect-winston,#{$gallery_id} .modula-item.effect-selena,#{$gallery_id} .modula-item.effect-terry,#{$gallery_id} .modula-item.effect-phoebe,#{$gallery_id} .modula-item.effect-apollo{ background-color:" . modula_pro_sanitize_color( $settings['hoverColor'] ) . '; }';

			$css .= "#{$gallery_id}  .modula-item.effect-oscar { background: -webkit-linear-gradient(45deg," . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#9b4a1b 40%,' . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 100%);background: linear-gradient(45deg,' . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#9b4a1b 40%,' . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 100%);}';

			$css .= "#{$gallery_id}  .modula-item.effect-roxy {background: -webkit-linear-gradient(45deg," . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#05abe0 100%);background: linear-gradient(45deg,' . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#05abe0 100%);}';

			$css .= "#{$gallery_id} .modula-item.effect-dexter {background: -webkit-linear-gradient(top," . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,rgba(104,60,19,1) 100%); background: linear-gradient(to bottom,' . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,rgba(104,60,19,1) 100%);}';

			$css .= "#{$gallery_id}  .modula-item.effect-jazz {background: -webkit-linear-gradient(-45deg," . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#f33f58 100%);background: linear-gradient(-45deg,' . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#f33f58 100%);}';

			$css .= "#{$gallery_id} .modula-item.effect-lexi {background: -webkit-linear-gradient(-45deg," . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#fff 100%);background: linear-gradient(-45deg,' . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#fff 100%);}';

			$css .= "#{$gallery_id} .modula-item.effect-duke {background: -webkit-linear-gradient(-45deg," . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#cc6055 100%);background: linear-gradient(-45deg,' . modula_pro_sanitize_color( $settings['hoverColor'] ) . ' 0,#cc6055 100%);}';

			$css .= "#{$gallery_id} .modula-item.effect-ming .figc::before {border: 2px solid " . modula_pro_sanitize_color( $settings['hoverColor'] ) . '; box-shadow: 0 0 0 100vmax ' . modula_pro_hex_to_rgb( modula_pro_sanitize_color( $settings['hoverColor'] ), absint( $settings['hoverOpacity'] ) ) . ';}';
		}

		if ( isset( $settings['hoverOpacity'] ) && isset( $settings['effect'] ) && absint( $settings['hoverOpacity'] ) <= 100 && 'none' !== $settings['effect'] ) {
			$css .= "#{$gallery_id} .modula-item:hover img { opacity: " . ( 1 - absint( $settings['hoverOpacity'] ) / 100 ) . '; }';
		}

		// Settings for cursor preview
		if ( isset( $settings['cursor'] ) && isset( $settings['uploadCursor'] ) && 'custom' === $settings['cursor'] && 0 !== $settings['uploadCursor'] ) {
			$image_src = wp_get_attachment_image_src( $settings['uploadCursor'] );
			$css      .= "#{$gallery_id} .modula-item > a, #{$gallery_id} .modula-item, #{$gallery_id} .modula-item-content > a { cursor:url(" . esc_url( $image_src[0] ) . '),auto ; } ';
		}

		// Settings for font family caption and title
		if ( isset( $settings['captionsFontFamily'] ) && 'Default' !== $settings['captionsFontFamily'] && '' !== $settings['captionsFontFamily'] ) {
			$css .= "#{$gallery_id} .description{ font-family:" . esc_attr( $settings['captionsFontFamily'] ) . '; }';
		}

		if ( isset( $settings['titleFontFamily'] ) && 'Default' !== $settings['titleFontFamily'] && '' !== $settings['titleFontFamily'] ) {
			$css .= "#{$gallery_id} .jtg-title{ font-family:" . esc_attr( $settings['titleFontFamily'] ) . '; }';
		}
		// End of font family caption and title

		// Settings for Title Font Weight
		if ( isset( $settings['titleFontWeight'] ) && 'default' !== $settings['titleFontWeight'] ) {
			$css .= "#{$gallery_id} .jtg-title {font-weight:" . esc_attr( $settings['titleFontWeight'] ) . '; }';
		}

		// Settings for Captions Font Weight
		if ( isset( $settings['captionFontWeight'] ) && 'default' !== $settings['captionFontWeight'] ) {
			$css .= "#{$gallery_id} p.description {font-weight:" . esc_attr( $settings['captionFontWeight'] ) . '; }';
		}

		if ( isset( $settings['loadedHSlide'] ) && isset( $settings['loadedScale'] ) && isset( $settings['loadedVSlide'] ) && isset( $settings['loadedRotate'] ) ) {
			$css .= "#{$gallery_id}:not(.modula-loaded-scale)  .modula-item .modula-item-content { transform: scale(" . sanitize_text_field( $settings['loadedScale'] ) / 100 . ') translate(' . sanitize_text_field( $settings['loadedHSlide'] ) . 'px,' . sanitize_text_field( $settings['loadedVSlide'] ) . 'px) rotate(' . sanitize_text_field( $settings['loadedRotate'] ) . 'deg); }';

			$css .= '@keyframes modulaScaling { 0% {transform: scale(1) translate(0px,p0x) rotate(0deg);} 50%{transform: scale(' . sanitize_text_field( $settings['loadedScale'] ) / 100 . ') translate(' . sanitize_text_field( $settings['loadedHSlide'] ) . 'px,' . sanitize_text_field( $settings['loadedVSlide'] ) . 'px) rotate(' . sanitize_text_field( $settings['loadedRotate'] ) . 'deg);}100%{transform: scale(1) translate(0px,p0x) rotate(0deg);}}';
		}

		// Filter Text Alignment
		if ( isset( $settings['filterTextAlignment'] ) && 'none' !== $settings['filterTextAlignment'] ) {
			$css .= '#' . $gallery_id . '.modula-gallery .filters { text-align: ' . esc_attr( $settings['filterTextAlignment'] ) . ';}';
		}

		if ( isset( $settings['filterLinkColor'] ) && '' !== $settings['filterLinkColor'] ) {
			$css .= '#' . $gallery_id . '.modula-gallery .filters a {color: ' . modula_pro_sanitize_color( $settings['filterLinkColor'] ) . ' !important;}';
		}

		if ( isset( $settings['filterLinkHoverColor'] ) && '' !== $settings['filterLinkHoverColor'] ) {
			$css .= '#' . $gallery_id . ' .menu--ceres .modula_menu__item::before, #' . $gallery_id . ' .menu--ceres .modula_menu__item::after, #' . $gallery_id . ' .menu--ceres .modula_menu__link::after,#' . $gallery_id . ' .menu--ariel .modula_menu__item::before, #' . $gallery_id . ' .menu--ariel .modula_menu__item::after, #' . $gallery_id . ' .menu--ariel .modula_menu__link::after, #' . $gallery_id . ' .menu--ariel .modula_menu__link::before{background-color: ' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ' !important;}#' . $gallery_id . '.modula-gallery .filters a:hover, #' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current a {color: ' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ' !important;border-color: ' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ' !important}#' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current a:hover:before,#' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current a:hover:after,#' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current:hover:before,#' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current:hover:after { border-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . '}#' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current a:before,#' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current a:after,#' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current:before,#' . $gallery_id . '.modula-gallery .filters li.modula_menu__item--current:after{border-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . '; background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Antonio
			$css .= '#' . $gallery_id . '.modula .menu--antonio .modula_menu__item::after, #' . $gallery_id . '.modula .menu--antonio .modula_menu__item::before, #' . $gallery_id . '.modula .menu--antonio .modula_menu__link::after, #' . $gallery_id . '.modula .menu--antonio .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Caliban
			$css .= '#' . $gallery_id . '.modula .menu--caliban .modula_menu__link::before,#' . $gallery_id . '.modula .menu--caliban .modula_menu__link::after{border-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Ferdinand
			$css .= '#' . $gallery_id . '.modula .menu--ferdinand .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Francisco & Trinculo
			$css .= '#' . $gallery_id . '.modula .menu--francisco .modula_menu__link::before, #' . $gallery_id . '.modula .menu--trinculo .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Horatio
			$css .= '#' . $gallery_id . '.modula .menu--horatio .modula_menu__item a::after, #' . $gallery_id . '.modula .menu--horatio .modula_menu__item a::before, #' . $gallery_id . '.modula .menu--horatio .modula_menu__item::after, #' . $gallery_id . '.modula .menu--horatio .modula_menu__item::before{border-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . '}';

			// Invulner
			$css .= '#' . $gallery_id . '.modula .menu--invulner .modula_menu__link::before{border-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . '}';

			// Iris
			$css .= '#' . $gallery_id . '.modula .menu--iris .modula_menu__link::after, #' . $gallery_id . '.modula .menu--iris .modula_menu__link::before{border-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . '}';

			// Juno
			$css .= '#' . $gallery_id . '.modula .menu--juno .modula_menu__item::after,#' . $gallery_id . '.modula .menu--juno .modula_menu__item::before,#' . $gallery_id . '.modula .menu--juno .modula_menu__link::after,#' . $gallery_id . '.modula .menu--juno .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Maria
			$css .= '#' . $gallery_id . '.modula .menu--maria .modula_menu__item::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Miranda
			$css .= '#' . $gallery_id . '.modula .menu--miranda .modula_menu__item::after,#' . $gallery_id . '.modula .menu--miranda .modula_menu__item::before,#' . $gallery_id . '.modula .menu--miranda .modula_menu__link::after,#' . $gallery_id . '.modula .menu--miranda .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Prospero
			$css .= '#' . $gallery_id . '.modula .menu--prospero .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Sebastian
			$css .= '#' . $gallery_id . '.modula .menu--sebastian .modula_menu__link::after,#' . $gallery_id . '.modula .menu--sebastian .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Shylock
			$css .= '#' . $gallery_id . '.modula .menu--shylock .modula_menu__link::after{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Stephano
			$css .= '#' . $gallery_id . '.modula .menu--stephano .modula_menu__item::before,#' . $gallery_id . '.modula .menu--stephano .modula_menu__link::after,#' . $gallery_id . '.modula .menu--stephano .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			// Tantalid
			$css .= '#' . $gallery_id . '.modula .menu--tantalid .modula_menu__link::after,#' . $gallery_id . '.modula .menu--tantalid .modula_menu__link::before{border-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . '}';

			// Valentin
			$css .= '#' . $gallery_id . '.modula .menu--valentine .modula_menu__item::after,#' . $gallery_id . '.modula .menu--valentine .modula_menu__item::before,#' . $gallery_id . '.modula .menu--valentine .modula_menu__link::after,#' . $gallery_id . '.modula .menu--valentine .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';

			$css .= '#' . $gallery_id . '.modula .menu--viola .modula_menu__item::after,#' . $gallery_id . '.modula .menu--viola .modula_menu__item::before,#' . $gallery_id . '.modula .menu--viola .modula_menu__link::after,#' . $gallery_id . '.modula .menu--viola .modula_menu__link::before{background-color:' . modula_pro_sanitize_color( $settings['filterLinkHoverColor'] ) . ';}';
		}

		// Terry
		$css .= '#' . $gallery_id . '.modula-gallery .modula-item.effect-terry .jtg-social a:not(:last-child){margin-bottom:' . absint( $settings['socialIconPadding'] ) . 'px;}';

		// caption positioning
		if ( isset( $settings['captionPosition'] ) ) {
			$css .= '.modula-fancybox-container.modula-lightbox-' . $gallery_id . ' .modula-fancybox-caption .modula-fancybox-caption__body, .modula-fancybox-container.modula-lightbox-' . $gallery_id . ' .modula-fancybox-caption .modula-fancybox-caption__body p {text-align:' . esc_attr( $settings['captionPosition'] ) . '}';
		}

		if ( ! isset( $settings['show_navigation'] ) || 1 !== absint( $settings['show_navigation'] ) ) {
			$css .= 'html body .modula-fancybox-container.modula-lightbox-' . $gallery_id . ' .fancybox__nav{display:none}';
		}

		// Effect Under
		$css .= 'html body .modula.modula-columns .modula-items.grid-gallery .modula-item.effect-under .modula-item-content { height:auto;}';
		$css .= '@media all and (max-width: 768px) { .modula-gallery .modula-item.effect-under.modula-caption-effect-item.jg-entry { margin-top: ' . ( isset( $settings['mobile_gutter'] ) ? $settings['mobile_gutter'] : 10 ) . 'px; } }';

		// caption positioning
		if ( isset( $settings['captionPosition'] ) ) {
			$pos = 'center';
			if ( 'left' === $settings['captionPosition'] ) {
				$pos = 'flex-start';
			} elseif ( 'right' === $settings['captionPosition'] ) {
				$pos = 'flex-end';
			}
			$css .= '.modula-fancybox-container.modula-lightbox-' . $gallery_id . ' .fancybox__caption {align-self:' . esc_attr( $pos ) . '}';
		}

		if ( isset( $settings['lightbox_background_color'] ) && '' !== $settings['lightbox_background_color'] ) {
			$css .= '.modula-fancybox-container.modula-lightbox-' . $gallery_id . ' {--fancybox-bg:' . modula_pro_sanitize_color( $settings['lightbox_background_color'] ) . ';--fancybox-opacity:1 !important;}';
		}

		return $css;
	}
}
