<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Helper {

	public static function remove_empty_items( $arr ) {

		if ( ! is_array( $arr ) ) {
			return false;
		}

		if ( empty( $arr ) ) {
			return $arr;
		}

		$new_array = array();

		foreach ( $arr as $value ) {
			if ( '' !== $value ) {
				$new_array[] = $value;
			}
		}

		return $new_array;
	}

	public static function get_plugins( $plugin_folder = '' ) {
		if ( ! function_exists( 'get_plugins' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		return get_plugins( $plugin_folder );
	}

	public static function _get_plugin_basename_from_slug( $slug ) {
		$keys = array_keys( self::get_plugins() );
		foreach ( $keys as $key ) {
			if ( preg_match( '|^' . $slug . '/|', $key ) ) {
				return $key;
			}

			if ( 'modula-best-grid-gallery' === $slug ) {
				if ( preg_match( '|^modula-lite/|', $key ) ) {
					return $key;
				}
			}
		}
		return $slug;
	}

	public static function check_plugin_is_installed( $slug ) {
		$plugin_path = self::_get_plugin_basename_from_slug( $slug );
		if ( file_exists( WP_PLUGIN_DIR . '/' . $plugin_path ) ) {
			return true;
		}

		if ( 'modula-best-grid-gallery' === $slug ) {
			return file_exists( WP_PLUGIN_DIR . '/modula-lite' );
		}

		return false;
	}

	/**
	 * @return bool
	 */
	public static function check_plugin_is_active( $slug ) {
		$plugin_path = self::_get_plugin_basename_from_slug( $slug );
		$exists      = self::check_plugin_is_installed( $slug );
		if ( $exists ) {
			include_once ABSPATH . 'wp-admin/includes/plugin.php';

			$active = is_plugin_active( $plugin_path );

			if ( $active ) {
				return $active;
			}

			if ( 'modula-best-grid-gallery' === $slug ) {
				$active = is_plugin_active( str_replace( 'modula-best-grid-gallery', 'modula-lite', $plugin_path ) );
			}

			return $active;
		}

		return false;
	}

	public static function get_google_fonts() {
		return '[{"family":"Default"},{"family":"ABeeZee","category":"sans-serif","variants":["regular","italic"],"subsets":["latin"],"version":"v13","lastModified":"2019-07-17"},{"family":"Abel","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-17"},{"family":"Abhaya Libre","category":"serif","variants":["regular","500","600","700","800"],"subsets":["sinhala","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Abril Fatface","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-17"},{"family":"Aclonica","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Acme","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-17"},{"family":"Actor","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Adamina","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v13","lastModified":"2019-07-16"},{"family":"Advent Pro","category":"sans-serif","variants":["100","200","300","regular","500","600","700"],"subsets":["latin","latin-ext","greek"],"version":"v10","lastModified":"2019-07-16"},{"family":"Aguafina Script","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Akronim","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Aladin","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Aldrich","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Alef","category":"sans-serif","variants":["regular","700"],"subsets":["hebrew","latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Alegreya","category":"serif","variants":["regular","italic","500","500italic","700","700italic","800","800italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v13","lastModified":"2019-07-17"},{"family":"Alegreya SC","category":"serif","variants":["regular","italic","500","500italic","700","700italic","800","800italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v11","lastModified":"2019-07-16"},{"family":"Alegreya Sans","category":"sans-serif","variants":["100","100italic","300","300italic","regular","italic","500","500italic","700","700italic","800","800italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v10","lastModified":"2019-07-17"},{"family":"Alegreya Sans SC","category":"sans-serif","variants":["100","100italic","300","300italic","regular","italic","500","500italic","700","700italic","800","800italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v9","lastModified":"2019-07-16"},{"family":"Aleo","category":"serif","variants":["300","300italic","regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Alex Brush","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Alfa Slab One","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Alice","category":"serif","variants":["regular"],"subsets":["cyrillic-ext","latin","cyrillic"],"version":"v11","lastModified":"2019-07-16"},{"family":"Alike","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Alike Angular","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Allan","category":"display","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"Allerta","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Allerta Stencil","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Allura","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Almarai","category":"sans-serif","variants":["300","regular","700","800"],"subsets":["arabic"],"version":"v2","lastModified":"2019-09-17"},{"family":"Almendra","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"Almendra Display","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Almendra SC","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Amarante","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Amaranth","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Amatic SC","category":"handwriting","variants":["regular","700"],"subsets":["vietnamese","hebrew","latin","latin-ext","cyrillic"],"version":"v13","lastModified":"2019-07-17"},{"family":"Amethysta","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Amiko","category":"sans-serif","variants":["regular","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Amiri","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext","arabic"],"version":"v13","lastModified":"2019-07-17"},{"family":"Amita","category":"handwriting","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Anaheim","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Andada","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Andika","category":"sans-serif","variants":["regular"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-16"},{"family":"Angkor","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v12","lastModified":"2019-07-16"},{"family":"Annie Use Your Telescope","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Anonymous Pro","category":"monospace","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext","greek","cyrillic"],"version":"v13","lastModified":"2019-07-16"},{"family":"Antic","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Antic Didone","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Antic Slab","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Anton","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v11","lastModified":"2019-07-17"},{"family":"Arapey","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Arbutus","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Arbutus Slab","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Architects Daughter","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Archivo","category":"sans-serif","variants":["regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v6","lastModified":"2019-07-26"},{"family":"Archivo Black","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Archivo Narrow","category":"sans-serif","variants":["regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v11","lastModified":"2019-07-26"},{"family":"Aref Ruqaa","category":"serif","variants":["regular","700"],"subsets":["latin","arabic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Arima Madurai","category":"display","variants":["100","200","300","regular","500","700","800","900"],"subsets":["vietnamese","latin","latin-ext","tamil"],"version":"v5","lastModified":"2019-07-16"},{"family":"Arimo","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","hebrew","latin","latin-ext","greek","cyrillic"],"version":"v13","lastModified":"2019-07-22"},{"family":"Arizonia","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Armata","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Arsenal","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v4","lastModified":"2019-07-16"},{"family":"Artifika","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Arvo","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v13","lastModified":"2019-07-26"},{"family":"Arya","category":"sans-serif","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Asap","category":"sans-serif","variants":["regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v11","lastModified":"2019-07-26"},{"family":"Asap Condensed","category":"sans-serif","variants":["regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-26"},{"family":"Asar","category":"serif","variants":["regular"],"subsets":["devanagari","latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Asset","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Assistant","category":"sans-serif","variants":["200","300","regular","600","700","800"],"subsets":["hebrew","latin"],"version":"v4","lastModified":"2019-07-17"},{"family":"Astloch","category":"display","variants":["regular","700"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-26"},{"family":"Asul","category":"sans-serif","variants":["regular","700"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Athiti","category":"sans-serif","variants":["200","300","regular","500","600","700"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Atma","category":"display","variants":["300","regular","500","600","700"],"subsets":["bengali","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Atomic Age","category":"display","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Aubrey","category":"display","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Audiowide","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Autour One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Average","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Average Sans","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Averia Gruesa Libre","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Averia Libre","category":"display","variants":["300","300italic","regular","italic","700","700italic"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Averia Sans Libre","category":"display","variants":["300","300italic","regular","italic","700","700italic"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Averia Serif Libre","category":"display","variants":["300","300italic","regular","italic","700","700italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"B612","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v4","lastModified":"2019-11-05"},{"family":"B612 Mono","category":"monospace","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v4","lastModified":"2019-11-05"},{"family":"Bad Script","category":"handwriting","variants":["regular"],"subsets":["latin","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Bahiana","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Bahianita","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v2","lastModified":"2019-11-05"},{"family":"Bai Jamjuree","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Baloo","category":"display","variants":["regular"],"subsets":["devanagari","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Baloo Bhai","category":"display","variants":["regular"],"subsets":["gujarati","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Baloo Bhaijaan","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","arabic"],"version":"v6","lastModified":"2019-09-17"},{"family":"Baloo Bhaina","category":"display","variants":["regular"],"subsets":["vietnamese","latin","oriya","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Baloo Chettan","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","malayalam"],"version":"v5","lastModified":"2019-07-16"},{"family":"Baloo Da","category":"display","variants":["regular"],"subsets":["bengali","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Baloo Paaji","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","gurmukhi"],"version":"v6","lastModified":"2019-07-16"},{"family":"Baloo Tamma","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","kannada"],"version":"v6","lastModified":"2019-07-16"},{"family":"Baloo Tammudu","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","telugu"],"version":"v6","lastModified":"2019-07-16"},{"family":"Baloo Thambi","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","tamil"],"version":"v5","lastModified":"2019-07-16"},{"family":"Balthazar","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Bangers","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"Barlow","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-17"},{"family":"Barlow Condensed","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-17"},{"family":"Barlow Semi Condensed","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-17"},{"family":"Barriecito","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v2","lastModified":"2019-11-05"},{"family":"Barrio","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Basic","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Battambang","category":"display","variants":["regular","700"],"subsets":["khmer"],"version":"v13","lastModified":"2019-07-16"},{"family":"Baumans","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Bayon","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v13","lastModified":"2019-07-16"},{"family":"Be Vietnam","category":"sans-serif","variants":["100","100italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-09-17"},{"family":"Bebas Neue","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v1","lastModified":"2019-11-13"},{"family":"Belgrano","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Bellefair","category":"serif","variants":["regular"],"subsets":["hebrew","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Belleza","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"BenchNine","category":"sans-serif","variants":["300","regular","700"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Bentham","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Berkshire Swash","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Beth Ellen","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v1","lastModified":"2019-11-05"},{"family":"Bevan","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Big Shoulders Display","category":"display","variants":["100","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-09-17"},{"family":"Big Shoulders Text","category":"display","variants":["100","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-09-17"},{"family":"Bigelow Rules","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Bigshot One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Bilbo","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Bilbo Swash Caps","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"BioRhyme","category":"serif","variants":["200","300","regular","700","800"],"subsets":["latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"BioRhyme Expanded","category":"serif","variants":["200","300","regular","700","800"],"subsets":["latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Biryani","category":"sans-serif","variants":["200","300","regular","600","700","800","900"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Bitter","category":"serif","variants":["regular","italic","700"],"subsets":["latin","latin-ext"],"version":"v15","lastModified":"2019-07-22"},{"family":"Black And White Picture","category":"sans-serif","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Black Han Sans","category":"sans-serif","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Black Ops One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Blinker","category":"sans-serif","variants":["100","200","300","regular","600","700","800","900"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Bokor","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v12","lastModified":"2019-07-16"},{"family":"Bonbon","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Boogaloo","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Bowlby One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Bowlby One SC","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Brawler","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Bree Serif","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Bubblegum Sans","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Bubbler One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Buda","category":"display","variants":["300"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Buenard","category":"serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Bungee","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Bungee Hairline","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Bungee Inline","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Bungee Outline","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Bungee Shade","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Butcherman","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Butterfly Kids","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cabin","category":"sans-serif","variants":["regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v14","lastModified":"2019-07-22"},{"family":"Cabin Condensed","category":"sans-serif","variants":["regular","500","600","700"],"subsets":["vietnamese","latin","latin-ext"],"version":"v13","lastModified":"2019-07-17"},{"family":"Cabin Sketch","category":"display","variants":["regular","700"],"subsets":["latin"],"version":"v13","lastModified":"2019-07-16"},{"family":"Caesar Dressing","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cagliostro","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cairo","category":"sans-serif","variants":["200","300","regular","600","700","900"],"subsets":["latin","latin-ext","arabic"],"version":"v6","lastModified":"2019-07-17"},{"family":"Calligraffitti","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Cambay","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["devanagari","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Cambo","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Candal","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Cantarell","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-17"},{"family":"Cantata One","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Cantora One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Capriola","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Cardo","category":"serif","variants":["regular","italic","700"],"subsets":["greek-ext","latin","latin-ext","greek"],"version":"v11","lastModified":"2019-07-17"},{"family":"Carme","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Carrois Gothic","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Carrois Gothic SC","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Carter One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Catamaran","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["latin","latin-ext","tamil"],"version":"v6","lastModified":"2019-07-17"},{"family":"Caudex","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["greek-ext","latin","latin-ext","greek"],"version":"v9","lastModified":"2019-07-16"},{"family":"Caveat","category":"handwriting","variants":["regular","700"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v7","lastModified":"2019-07-17"},{"family":"Caveat Brush","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Cedarville Cursive","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Ceviche One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Chakra Petch","category":"sans-serif","variants":["300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Changa","category":"sans-serif","variants":["200","300","regular","500","600","700","800"],"subsets":["latin","latin-ext","arabic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Changa One","category":"display","variants":["regular","italic"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Chango","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Charm","category":"handwriting","variants":["regular","700"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-11-05"},{"family":"Charmonman","category":"handwriting","variants":["regular","700"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Chathura","category":"sans-serif","variants":["100","300","regular","700","800"],"subsets":["latin","telugu"],"version":"v5","lastModified":"2019-07-16"},{"family":"Chau Philomene One","category":"sans-serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Chela One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Chelsea Market","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Chenla","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v12","lastModified":"2019-07-16"},{"family":"Cherry Cream Soda","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Cherry Swash","category":"display","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Chewy","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Chicle","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Chilanka","category":"handwriting","variants":["regular"],"subsets":["latin","malayalam"],"version":"v5","lastModified":"2019-08-22"},{"family":"Chivo","category":"sans-serif","variants":["300","300italic","regular","italic","700","700italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-17"},{"family":"Chonburi","category":"display","variants":["regular"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Cinzel","category":"serif","variants":["regular","700","900"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Cinzel Decorative","category":"display","variants":["regular","700","900"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Clicker Script","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Coda","category":"display","variants":["regular","800"],"subsets":["latin","latin-ext"],"version":"v15","lastModified":"2019-07-16"},{"family":"Coda Caption","category":"sans-serif","variants":["800"],"subsets":["latin","latin-ext"],"version":"v13","lastModified":"2019-07-16"},{"family":"Codystar","category":"display","variants":["300","regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Coiny","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","tamil"],"version":"v5","lastModified":"2019-07-16"},{"family":"Combo","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Comfortaa","category":"display","variants":["300","regular","500","600","700"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v27","lastModified":"2019-10-22"},{"family":"Coming Soon","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-26"},{"family":"Concert One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-17"},{"family":"Condiment","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Content","category":"display","variants":["regular","700"],"subsets":["khmer"],"version":"v12","lastModified":"2019-07-16"},{"family":"Contrail One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Convergence","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cookie","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-17"},{"family":"Copse","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Corben","category":"display","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v13","lastModified":"2019-07-16"},{"family":"Cormorant","category":"serif","variants":["300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cormorant Garamond","category":"serif","variants":["300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v7","lastModified":"2019-07-17"},{"family":"Cormorant Infant","category":"serif","variants":["300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cormorant SC","category":"serif","variants":["300","regular","500","600","700"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cormorant Unicase","category":"serif","variants":["300","regular","500","600","700"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cormorant Upright","category":"serif","variants":["300","regular","500","600","700"],"subsets":["vietnamese","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Courgette","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-17"},{"family":"Cousine","category":"monospace","variants":["regular","italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","hebrew","latin","latin-ext","greek","cyrillic"],"version":"v14","lastModified":"2019-07-16"},{"family":"Coustard","category":"serif","variants":["regular","900"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Covered By Your Grace","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Crafty Girls","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Creepster","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Crete Round","category":"serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-17"},{"family":"Crimson Pro","category":"serif","variants":["200","300","regular","500","600","700","800","900","200italic","300italic","italic","500italic","600italic","700italic","800italic","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v11","lastModified":"2019-10-21"},{"family":"Crimson Text","category":"serif","variants":["regular","italic","600","600italic","700","700italic"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-22"},{"family":"Croissant One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Crushed","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Cuprum","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-17"},{"family":"Cute Font","category":"display","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Cutive","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Cutive Mono","category":"monospace","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"DM Sans","category":"sans-serif","variants":["regular","italic","500","500italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"DM Serif Display","category":"serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"DM Serif Text","category":"serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Damion","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Dancing Script","category":"handwriting","variants":["regular","700"],"subsets":["vietnamese","latin","latin-ext"],"version":"v11","lastModified":"2019-07-17"},{"family":"Dangrek","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v11","lastModified":"2019-07-16"},{"family":"Darker Grotesque","category":"sans-serif","variants":["300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-11-05"},{"family":"David Libre","category":"serif","variants":["regular","500","700"],"subsets":["vietnamese","hebrew","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Dawning of a New Day","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Days One","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Dekko","category":"handwriting","variants":["regular"],"subsets":["devanagari","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Delius","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Delius Swash Caps","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Delius Unicase","category":"handwriting","variants":["regular","700"],"subsets":["latin"],"version":"v13","lastModified":"2019-07-16"},{"family":"Della Respira","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Denk One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Devonshire","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Dhurjati","category":"sans-serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v7","lastModified":"2019-07-16"},{"family":"Didact Gothic","category":"sans-serif","variants":["regular"],"subsets":["greek-ext","cyrillic-ext","latin","latin-ext","greek","cyrillic"],"version":"v13","lastModified":"2019-07-17"},{"family":"Diplomata","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Diplomata SC","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Do Hyeon","category":"sans-serif","variants":["regular"],"subsets":["latin","korean"],"version":"v11","lastModified":"2019-07-16"},{"family":"Dokdo","category":"handwriting","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Domine","category":"serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-17"},{"family":"Donegal One","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Doppio One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Dorsa","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Dosis","category":"sans-serif","variants":["200","300","regular","500","600","700","800"],"subsets":["vietnamese","latin","latin-ext"],"version":"v16","lastModified":"2019-10-22"},{"family":"Dr Sugiyama","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Duru Sans","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v13","lastModified":"2019-07-16"},{"family":"Dynalight","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"EB Garamond","category":"serif","variants":["regular","500","600","700","800","italic","500italic","600italic","700italic","800italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v12","lastModified":"2019-11-13"},{"family":"Eagle Lake","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"East Sea Dokdo","category":"handwriting","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Eater","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Economica","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Eczar","category":"serif","variants":["regular","500","600","700","800"],"subsets":["devanagari","latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"El Messiri","category":"sans-serif","variants":["regular","500","600","700"],"subsets":["latin","arabic","cyrillic"],"version":"v6","lastModified":"2019-07-16"},{"family":"Electrolize","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Elsie","category":"display","variants":["regular","900"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Elsie Swash Caps","category":"display","variants":["regular","900"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Emblema One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Emilys Candy","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Encode Sans","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Encode Sans Condensed","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Encode Sans Expanded","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Encode Sans Semi Condensed","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Encode Sans Semi Expanded","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Engagement","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Englebert","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Enriqueta","category":"serif","variants":["regular","500","600","700"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-26"},{"family":"Erica One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Esteban","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Euphoria Script","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Ewert","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Exo","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Exo 2","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v7","lastModified":"2019-09-17"},{"family":"Expletus Sans","category":"display","variants":["regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["latin"],"version":"v13","lastModified":"2019-07-16"},{"family":"Fahkwang","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Fanwood Text","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Farro","category":"sans-serif","variants":["300","regular","500","700"],"subsets":["latin","latin-ext"],"version":"v1","lastModified":"2019-11-05"},{"family":"Farsan","category":"display","variants":["regular"],"subsets":["gujarati","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Fascinate","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Fascinate Inline","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Faster One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Fasthand","category":"serif","variants":["regular"],"subsets":["khmer"],"version":"v10","lastModified":"2019-07-16"},{"family":"Fauna One","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Faustina","category":"serif","variants":["regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Federant","category":"display","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Federo","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Felipa","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Fenix","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Finger Paint","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Fira Code","category":"monospace","variants":["300","regular","500","600","700"],"subsets":["greek-ext","cyrillic-ext","latin","latin-ext","greek","cyrillic"],"version":"v7","lastModified":"2019-10-22"},{"family":"Fira Mono","category":"monospace","variants":["regular","500","700"],"subsets":["greek-ext","cyrillic-ext","latin","latin-ext","greek","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Fira Sans","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v10","lastModified":"2019-07-22"},{"family":"Fira Sans Condensed","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v4","lastModified":"2019-07-17"},{"family":"Fira Sans Extra Condensed","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v4","lastModified":"2019-07-17"},{"family":"Fjalla One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-17"},{"family":"Fjord One","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Flamenco","category":"display","variants":["300","regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Flavors","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-26"},{"family":"Fondamento","category":"handwriting","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Fontdiner Swanky","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Forum","category":"display","variants":["regular"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v10","lastModified":"2019-07-16"},{"family":"Francois One","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v14","lastModified":"2019-07-17"},{"family":"Frank Ruhl Libre","category":"serif","variants":["300","regular","500","700","900"],"subsets":["hebrew","latin","latin-ext"],"version":"v5","lastModified":"2019-07-17"},{"family":"Freckle Face","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Fredericka the Great","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-26"},{"family":"Fredoka One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Freehand","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v11","lastModified":"2019-07-16"},{"family":"Fresca","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Frijole","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Fruktur","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"Fugaz One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"GFS Didot","category":"serif","variants":["regular"],"subsets":["greek"],"version":"v9","lastModified":"2019-07-16"},{"family":"GFS Neohellenic","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["greek"],"version":"v12","lastModified":"2019-07-16"},{"family":"Gabriela","category":"serif","variants":["regular"],"subsets":["cyrillic-ext","latin","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Gaegu","category":"handwriting","variants":["300","regular","700"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Gafata","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Galada","category":"display","variants":["regular"],"subsets":["bengali","latin"],"version":"v5","lastModified":"2019-07-16"},{"family":"Galdeano","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Galindo","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Gamja Flower","category":"handwriting","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Gayathri","category":"sans-serif","variants":["100","regular","700"],"subsets":["latin","malayalam"],"version":"v1","lastModified":"2019-11-05"},{"family":"Gentium Basic","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Gentium Book Basic","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Geo","category":"sans-serif","variants":["regular","italic"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Geostar","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Geostar Fill","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Germania One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Gidugu","category":"sans-serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v6","lastModified":"2019-07-16"},{"family":"Gilda Display","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Give You Glory","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Glass Antiqua","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Glegoo","category":"serif","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Gloria Hallelujah","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-17"},{"family":"Goblin One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Gochi Hand","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Gorditas","category":"display","variants":["regular","700"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Gothic A1","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Goudy Bookletter 1911","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Graduate","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Grand Hotel","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Gravitas One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Great Vibes","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-17"},{"family":"Grenze","category":"serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-11-05"},{"family":"Griffy","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Gruppo","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Gudea","category":"sans-serif","variants":["regular","italic","700"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Gugi","category":"display","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Gurajada","category":"serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v7","lastModified":"2019-07-16"},{"family":"Habibi","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Halant","category":"serif","variants":["300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Hammersmith One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Hanalei","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-09-17"},{"family":"Hanalei Fill","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Handlee","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Hanuman","category":"serif","variants":["regular","700"],"subsets":["khmer"],"version":"v13","lastModified":"2019-07-16"},{"family":"Happy Monkey","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Harmattan","category":"sans-serif","variants":["regular"],"subsets":["latin","arabic"],"version":"v6","lastModified":"2019-07-16"},{"family":"Headland One","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Heebo","category":"sans-serif","variants":["100","300","regular","500","700","800","900"],"subsets":["hebrew","latin"],"version":"v5","lastModified":"2019-07-22"},{"family":"Henny Penny","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Hepta Slab","category":"serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v6","lastModified":"2019-10-22"},{"family":"Herr Von Muellerhoff","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Hi Melody","category":"handwriting","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Hind","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v10","lastModified":"2019-07-22"},{"family":"Hind Guntur","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["latin","latin-ext","telugu"],"version":"v5","lastModified":"2019-07-16"},{"family":"Hind Madurai","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["latin","latin-ext","tamil"],"version":"v5","lastModified":"2019-07-17"},{"family":"Hind Siliguri","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["bengali","latin","latin-ext"],"version":"v6","lastModified":"2019-07-17"},{"family":"Hind Vadodara","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["gujarati","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Holtwood One SC","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Homemade Apple","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Homenaje","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IBM Plex Mono","category":"monospace","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v5","lastModified":"2019-07-16"},{"family":"IBM Plex Sans","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v7","lastModified":"2019-07-17"},{"family":"IBM Plex Sans Condensed","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"IBM Plex Serif","category":"serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"IM Fell DW Pica","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell DW Pica SC","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell Double Pica","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell Double Pica SC","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell English","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell English SC","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell French Canon","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell French Canon SC","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell Great Primer","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"IM Fell Great Primer SC","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Iceberg","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Iceland","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Imprima","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Inconsolata","category":"monospace","variants":["regular","700"],"subsets":["vietnamese","latin","latin-ext"],"version":"v18","lastModified":"2019-07-22"},{"family":"Inder","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Indie Flower","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-17"},{"family":"Inika","category":"serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Inknut Antiqua","category":"serif","variants":["300","regular","500","600","700","800","900"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Irish Grover","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Istok Web","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v14","lastModified":"2019-07-16"},{"family":"Italiana","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Italianno","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Itim","category":"handwriting","variants":["regular"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Jacques Francois","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Jacques Francois Shadow","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Jaldi","category":"sans-serif","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Jim Nightshade","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Jockey One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Jolly Lodger","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Jomhuria","category":"display","variants":["regular"],"subsets":["latin","latin-ext","arabic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Jomolhari","category":"serif","variants":["regular"],"subsets":["tibetan","latin"],"version":"v1","lastModified":"2019-10-15"},{"family":"Josefin Sans","category":"sans-serif","variants":["100","100italic","300","300italic","regular","italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v14","lastModified":"2019-07-22"},{"family":"Josefin Slab","category":"serif","variants":["100","100italic","300","300italic","regular","italic","600","600italic","700","700italic"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Joti One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Jua","category":"sans-serif","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Judson","category":"serif","variants":["regular","italic","700"],"subsets":["vietnamese","latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"Julee","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Julius Sans One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Junge","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Jura","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v13","lastModified":"2019-10-24"},{"family":"Just Another Hand","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Just Me Again Down Here","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"K2D","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Kadwa","category":"serif","variants":["regular","700"],"subsets":["devanagari","latin"],"version":"v4","lastModified":"2019-07-16"},{"family":"Kalam","category":"handwriting","variants":["300","regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v10","lastModified":"2019-07-17"},{"family":"Kameron","category":"serif","variants":["regular","700"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Kanit","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-17"},{"family":"Kantumruy","category":"sans-serif","variants":["300","regular","700"],"subsets":["khmer"],"version":"v7","lastModified":"2019-07-26"},{"family":"Karla","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-10-15"},{"family":"Karma","category":"serif","variants":["300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Katibeh","category":"display","variants":["regular"],"subsets":["latin","latin-ext","arabic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Kaushan Script","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-17"},{"family":"Kavivanar","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext","tamil"],"version":"v5","lastModified":"2019-07-16"},{"family":"Kavoon","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Kdam Thmor","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v7","lastModified":"2019-07-16"},{"family":"Keania One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Kelly Slab","category":"display","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v10","lastModified":"2019-07-16"},{"family":"Kenia","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Khand","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Khmer","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v12","lastModified":"2019-07-16"},{"family":"Khula","category":"sans-serif","variants":["300","regular","600","700","800"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Kirang Haerang","category":"display","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Kite One","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Knewave","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"KoHo","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Kodchasan","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Kosugi","category":"sans-serif","variants":["regular"],"subsets":["latin","japanese","cyrillic"],"version":"v6","lastModified":"2019-07-16"},{"family":"Kosugi Maru","category":"sans-serif","variants":["regular"],"subsets":["latin","japanese","cyrillic"],"version":"v6","lastModified":"2019-07-16"},{"family":"Kotta One","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Koulen","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v13","lastModified":"2019-07-16"},{"family":"Kranky","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Kreon","category":"serif","variants":["300","regular","500","600","700"],"subsets":["latin","latin-ext"],"version":"v21","lastModified":"2019-10-22"},{"family":"Kristi","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Krona One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Krub","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Kulim Park","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","600","600italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v1","lastModified":"2019-11-13"},{"family":"Kumar One","category":"display","variants":["regular"],"subsets":["gujarati","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Kumar One Outline","category":"display","variants":["regular"],"subsets":["gujarati","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Kurale","category":"serif","variants":["regular"],"subsets":["cyrillic-ext","devanagari","latin","latin-ext","cyrillic"],"version":"v5","lastModified":"2019-07-16"},{"family":"La Belle Aurore","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Lacquer","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v1","lastModified":"2019-11-05"},{"family":"Laila","category":"serif","variants":["300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Lakki Reddy","category":"handwriting","variants":["regular"],"subsets":["latin","telugu"],"version":"v6","lastModified":"2019-07-16"},{"family":"Lalezar","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","arabic"],"version":"v6","lastModified":"2019-07-16"},{"family":"Lancelot","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Lateef","category":"handwriting","variants":["regular"],"subsets":["latin","arabic"],"version":"v15","lastModified":"2019-07-16"},{"family":"Lato","category":"sans-serif","variants":["100","100italic","300","300italic","regular","italic","700","700italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v16","lastModified":"2019-07-23"},{"family":"League Script","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-26"},{"family":"Leckerli One","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Ledger","category":"serif","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Lekton","category":"sans-serif","variants":["regular","italic","700"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Lemon","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Lemonada","category":"display","variants":["300","regular","600","700"],"subsets":["vietnamese","latin","latin-ext","arabic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Lexend Deca","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-08-14"},{"family":"Lexend Exa","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-08-14"},{"family":"Lexend Giga","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-08-14"},{"family":"Lexend Mega","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-08-14"},{"family":"Lexend Peta","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-08-14"},{"family":"Lexend Tera","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-08-14"},{"family":"Lexend Zetta","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-08-14"},{"family":"Libre Barcode 128","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Libre Barcode 128 Text","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Libre Barcode 39","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Libre Barcode 39 Extended","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Libre Barcode 39 Extended Text","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Libre Barcode 39 Text","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Libre Baskerville","category":"serif","variants":["regular","italic","700"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-22"},{"family":"Libre Caslon Display","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v1","lastModified":"2019-07-26"},{"family":"Libre Caslon Text","category":"serif","variants":["regular","italic","700"],"subsets":["latin","latin-ext"],"version":"v1","lastModified":"2019-07-26"},{"family":"Libre Franklin","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v4","lastModified":"2019-07-22"},{"family":"Life Savers","category":"display","variants":["regular","700","800"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Lilita One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Lily Script One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Limelight","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Linden Hill","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Literata","category":"serif","variants":["regular","500","600","700","italic","500italic","600italic","700italic"],"subsets":["greek-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v14","lastModified":"2019-10-22"},{"family":"Liu Jian Mao Cao","category":"handwriting","variants":["regular"],"subsets":["latin","chinese-simplified"],"version":"v5","lastModified":"2019-11-05"},{"family":"Livvic","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Lobster","category":"display","variants":["regular"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v22","lastModified":"2019-07-17"},{"family":"Lobster Two","category":"display","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Londrina Outline","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Londrina Shadow","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Londrina Sketch","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Londrina Solid","category":"display","variants":["100","300","regular","900"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Long Cang","category":"handwriting","variants":["regular"],"subsets":["latin","chinese-simplified"],"version":"v5","lastModified":"2019-11-05"},{"family":"Lora","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v14","lastModified":"2019-07-22"},{"family":"Love Ya Like A Sister","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Loved by the King","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Lovers Quarrel","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Luckiest Guy","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Lusitana","category":"serif","variants":["regular","700"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Lustria","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"M PLUS 1p","category":"sans-serif","variants":["100","300","regular","500","700","800","900"],"subsets":["greek-ext","cyrillic-ext","vietnamese","hebrew","latin","latin-ext","japanese","greek","cyrillic"],"version":"v19","lastModified":"2019-07-23"},{"family":"M PLUS Rounded 1c","category":"sans-serif","variants":["100","300","regular","500","700","800","900"],"subsets":["greek-ext","cyrillic-ext","vietnamese","hebrew","latin","latin-ext","japanese","greek","cyrillic"],"version":"v10","lastModified":"2019-11-05"},{"family":"Ma Shan Zheng","category":"handwriting","variants":["regular"],"subsets":["latin","chinese-simplified"],"version":"v5","lastModified":"2019-11-05"},{"family":"Macondo","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Macondo Swash Caps","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Mada","category":"sans-serif","variants":["200","300","regular","500","600","700","900"],"subsets":["latin","arabic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Magra","category":"sans-serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Maiden Orange","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Maitree","category":"serif","variants":["200","300","regular","500","600","700"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Major Mono Display","category":"monospace","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Mako","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Mali","category":"handwriting","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Mallanna","category":"sans-serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v7","lastModified":"2019-07-16"},{"family":"Mandali","category":"sans-serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v8","lastModified":"2019-07-16"},{"family":"Manjari","category":"sans-serif","variants":["100","regular","700"],"subsets":["latin","malayalam"],"version":"v2","lastModified":"2019-11-05"},{"family":"Mansalva","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v1","lastModified":"2019-09-17"},{"family":"Manuale","category":"serif","variants":["regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Marcellus","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Marcellus SC","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Marck Script","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v10","lastModified":"2019-07-16"},{"family":"Margarine","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Markazi Text","category":"serif","variants":["regular","500","600","700"],"subsets":["vietnamese","latin","latin-ext","arabic"],"version":"v10","lastModified":"2019-10-22"},{"family":"Marko One","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Marmelad","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v9","lastModified":"2019-07-16"},{"family":"Martel","category":"serif","variants":["200","300","regular","600","700","800","900"],"subsets":["devanagari","latin","latin-ext"],"version":"v4","lastModified":"2019-07-17"},{"family":"Martel Sans","category":"sans-serif","variants":["200","300","regular","600","700","800","900"],"subsets":["devanagari","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Marvel","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Mate","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Mate SC","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Maven Pro","category":"sans-serif","variants":["regular","500","700","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v13","lastModified":"2019-10-15"},{"family":"McLaren","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Meddon","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"MedievalSharp","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"Medula One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Meera Inimai","category":"sans-serif","variants":["regular"],"subsets":["latin","tamil"],"version":"v4","lastModified":"2019-07-16"},{"family":"Megrim","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Meie Script","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Merienda","category":"handwriting","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-17"},{"family":"Merienda One","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Merriweather","category":"serif","variants":["300","300italic","regular","italic","700","700italic","900","900italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v21","lastModified":"2019-07-22"},{"family":"Merriweather Sans","category":"sans-serif","variants":["300","300italic","regular","italic","700","700italic","800","800italic"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-17"},{"family":"Metal","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v12","lastModified":"2019-07-16"},{"family":"Metal Mania","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Metamorphous","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Metrophobic","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v13","lastModified":"2019-07-16"},{"family":"Michroma","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Milonga","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Miltonian","category":"display","variants":["regular"],"subsets":["latin"],"version":"v13","lastModified":"2019-07-16"},{"family":"Miltonian Tattoo","category":"display","variants":["regular"],"subsets":["latin"],"version":"v15","lastModified":"2019-07-16"},{"family":"Mina","category":"sans-serif","variants":["regular","700"],"subsets":["bengali","latin","latin-ext"],"version":"v3","lastModified":"2019-07-16"},{"family":"Miniver","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Miriam Libre","category":"sans-serif","variants":["regular","700"],"subsets":["hebrew","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Mirza","category":"display","variants":["regular","500","600","700"],"subsets":["latin","latin-ext","arabic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Miss Fajardose","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Mitr","category":"sans-serif","variants":["200","300","regular","500","600","700"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Modak","category":"display","variants":["regular"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Modern Antiqua","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Mogra","category":"display","variants":["regular"],"subsets":["gujarati","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Molengo","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Molle","category":"handwriting","variants":["italic"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Monda","category":"sans-serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Monofett","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Monoton","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Monsieur La Doulaise","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Montaga","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Montez","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Montserrat","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v14","lastModified":"2019-07-23"},{"family":"Montserrat Alternates","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-16"},{"family":"Montserrat Subrayada","category":"sans-serif","variants":["regular","700"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Moul","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v11","lastModified":"2019-07-16"},{"family":"Moulpali","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v12","lastModified":"2019-07-16"},{"family":"Mountains of Christmas","category":"display","variants":["regular","700"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Mouse Memoirs","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Mr Bedfort","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Mr Dafoe","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Mr De Haviland","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Mrs Saint Delafield","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Mrs Sheppards","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Mukta","category":"sans-serif","variants":["200","300","regular","500","600","700","800"],"subsets":["devanagari","latin","latin-ext"],"version":"v7","lastModified":"2019-07-17"},{"family":"Mukta Mahee","category":"sans-serif","variants":["200","300","regular","500","600","700","800"],"subsets":["latin","latin-ext","gurmukhi"],"version":"v5","lastModified":"2019-07-16"},{"family":"Mukta Malar","category":"sans-serif","variants":["200","300","regular","500","600","700","800"],"subsets":["latin","latin-ext","tamil"],"version":"v6","lastModified":"2019-07-16"},{"family":"Mukta Vaani","category":"sans-serif","variants":["200","300","regular","500","600","700","800"],"subsets":["gujarati","latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Muli","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v16","lastModified":"2019-10-15"},{"family":"Mystery Quest","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"NTR","category":"sans-serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v7","lastModified":"2019-07-16"},{"family":"Nanum Brush Script","category":"handwriting","variants":["regular"],"subsets":["latin","korean"],"version":"v17","lastModified":"2019-07-16"},{"family":"Nanum Gothic","category":"sans-serif","variants":["regular","700","800"],"subsets":["latin","korean"],"version":"v17","lastModified":"2019-07-22"},{"family":"Nanum Gothic Coding","category":"monospace","variants":["regular","700"],"subsets":["latin","korean"],"version":"v14","lastModified":"2019-07-16"},{"family":"Nanum Myeongjo","category":"serif","variants":["regular","700","800"],"subsets":["latin","korean"],"version":"v15","lastModified":"2019-07-17"},{"family":"Nanum Pen Script","category":"handwriting","variants":["regular"],"subsets":["latin","korean"],"version":"v15","lastModified":"2019-07-16"},{"family":"Neucha","category":"handwriting","variants":["regular"],"subsets":["latin","cyrillic"],"version":"v11","lastModified":"2019-07-16"},{"family":"Neuton","category":"serif","variants":["200","300","regular","italic","700","800"],"subsets":["latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"New Rocker","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"News Cycle","category":"sans-serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v16","lastModified":"2019-07-17"},{"family":"Niconne","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Niramit","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-11-05"},{"family":"Nixie One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Nobile","category":"sans-serif","variants":["regular","italic","500","500italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Nokora","category":"serif","variants":["regular","700"],"subsets":["khmer"],"version":"v13","lastModified":"2019-07-16"},{"family":"Norican","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Nosifer","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Notable","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v4","lastModified":"2019-11-05"},{"family":"Nothing You Could Do","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Noticia Text","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Noto Sans","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","devanagari","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v9","lastModified":"2019-07-22"},{"family":"Noto Sans HK","category":"sans-serif","variants":["100","300","regular","500","700","900"],"subsets":["latin","chinese-hongkong"],"version":"v5","lastModified":"2019-07-16"},{"family":"Noto Sans JP","category":"sans-serif","variants":["100","300","regular","500","700","900"],"subsets":["latin","japanese"],"version":"v24","lastModified":"2019-07-22"},{"family":"Noto Sans KR","category":"sans-serif","variants":["100","300","regular","500","700","900"],"subsets":["latin","korean"],"version":"v12","lastModified":"2019-07-22"},{"family":"Noto Sans SC","category":"sans-serif","variants":["100","300","regular","500","700","900"],"subsets":["vietnamese","latin","chinese-simplified","cyrillic"],"version":"v9","lastModified":"2019-07-17"},{"family":"Noto Sans TC","category":"sans-serif","variants":["100","300","regular","500","700","900"],"subsets":["chinese-traditional","latin"],"version":"v9","lastModified":"2019-07-17"},{"family":"Noto Serif","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v8","lastModified":"2019-07-22"},{"family":"Noto Serif JP","category":"serif","variants":["200","300","regular","500","600","700","900"],"subsets":["latin","japanese"],"version":"v7","lastModified":"2019-07-16"},{"family":"Noto Serif KR","category":"serif","variants":["200","300","regular","500","600","700","900"],"subsets":["latin","korean"],"version":"v6","lastModified":"2019-07-16"},{"family":"Noto Serif SC","category":"serif","variants":["200","300","regular","500","600","700","900"],"subsets":["vietnamese","latin","chinese-simplified","cyrillic"],"version":"v6","lastModified":"2019-07-16"},{"family":"Noto Serif TC","category":"serif","variants":["200","300","regular","500","600","700","900"],"subsets":["chinese-traditional","vietnamese","latin","cyrillic"],"version":"v6","lastModified":"2019-07-16"},{"family":"Nova Cut","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Nova Flat","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Nova Mono","category":"monospace","variants":["regular"],"subsets":["latin","greek"],"version":"v10","lastModified":"2019-07-16"},{"family":"Nova Oval","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Nova Round","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Nova Script","category":"display","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Nova Slim","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Nova Square","category":"display","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Numans","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Nunito","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v11","lastModified":"2019-07-22"},{"family":"Nunito Sans","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-22"},{"family":"Odor Mean Chey","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v11","lastModified":"2019-07-16"},{"family":"Offside","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Old Standard TT","category":"serif","variants":["regular","italic","700"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v12","lastModified":"2019-07-17"},{"family":"Oldenburg","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Oleo Script","category":"display","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Oleo Script Swash Caps","category":"display","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Open Sans","category":"sans-serif","variants":["300","300italic","regular","italic","600","600italic","700","700italic","800","800italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v17","lastModified":"2019-07-23"},{"family":"Open Sans Condensed","category":"sans-serif","variants":["300","300italic","700"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v14","lastModified":"2019-07-22"},{"family":"Oranienbaum","category":"serif","variants":["regular"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Orbitron","category":"sans-serif","variants":["regular","500","700","900"],"subsets":["latin"],"version":"v11","lastModified":"2019-10-15"},{"family":"Oregano","category":"display","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Orienta","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Original Surfer","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Oswald","category":"sans-serif","variants":["200","300","regular","500","600","700"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v29","lastModified":"2019-10-22"},{"family":"Over the Rainbow","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Overlock","category":"display","variants":["regular","italic","700","700italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Overlock SC","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Overpass","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v4","lastModified":"2019-07-17"},{"family":"Overpass Mono","category":"monospace","variants":["300","regular","600","700"],"subsets":["latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Ovo","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Oxygen","category":"sans-serif","variants":["300","regular","700"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-22"},{"family":"Oxygen Mono","category":"monospace","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"PT Mono","category":"monospace","variants":["regular"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v7","lastModified":"2019-07-16"},{"family":"PT Sans","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-22"},{"family":"PT Sans Caption","category":"sans-serif","variants":["regular","700"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v12","lastModified":"2019-07-17"},{"family":"PT Sans Narrow","category":"sans-serif","variants":["regular","700"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-22"},{"family":"PT Serif","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-22"},{"family":"PT Serif Caption","category":"serif","variants":["regular","italic"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-16"},{"family":"Pacifico","category":"handwriting","variants":["regular"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v16","lastModified":"2019-09-17"},{"family":"Padauk","category":"sans-serif","variants":["regular","700"],"subsets":["myanmar","latin"],"version":"v6","lastModified":"2019-07-16"},{"family":"Palanquin","category":"sans-serif","variants":["100","200","300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Palanquin Dark","category":"sans-serif","variants":["regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Pangolin","category":"handwriting","variants":["regular"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v5","lastModified":"2019-07-16"},{"family":"Paprika","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Parisienne","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Passero One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Passion One","category":"display","variants":["regular","700","900"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Pathway Gothic One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-17"},{"family":"Patrick Hand","category":"handwriting","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v13","lastModified":"2019-07-16"},{"family":"Patrick Hand SC","category":"handwriting","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Pattaya","category":"sans-serif","variants":["regular"],"subsets":["thai","vietnamese","latin","latin-ext","cyrillic"],"version":"v5","lastModified":"2019-07-16"},{"family":"Patua One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-17"},{"family":"Pavanam","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext","tamil"],"version":"v4","lastModified":"2019-07-16"},{"family":"Paytone One","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v12","lastModified":"2019-07-16"},{"family":"Peddana","category":"serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v7","lastModified":"2019-07-16"},{"family":"Peralta","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Permanent Marker","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-17"},{"family":"Petit Formal Script","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Petrona","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Philosopher","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["cyrillic-ext","vietnamese","latin","cyrillic"],"version":"v11","lastModified":"2019-07-16"},{"family":"Piedra","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Pinyon Script","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Pirata One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Plaster","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Play","category":"sans-serif","variants":["regular","700"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v11","lastModified":"2019-07-17"},{"family":"Playball","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Playfair Display","category":"serif","variants":["regular","italic","700","700italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext","cyrillic"],"version":"v15","lastModified":"2019-10-15"},{"family":"Playfair Display SC","category":"serif","variants":["regular","italic","700","700italic","900","900italic"],"subsets":["vietnamese","latin","latin-ext","cyrillic"],"version":"v9","lastModified":"2019-07-16"},{"family":"Podkova","category":"serif","variants":["regular","500","600","700","800"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v15","lastModified":"2019-10-24"},{"family":"Poiret One","category":"display","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Poller One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Poly","category":"serif","variants":["regular","italic"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Pompiere","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Pontano Sans","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Poor Story","category":"display","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Poppins","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["devanagari","latin","latin-ext"],"version":"v9","lastModified":"2019-10-15"},{"family":"Port Lligat Sans","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Port Lligat Slab","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Pragati Narrow","category":"sans-serif","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Prata","category":"serif","variants":["regular"],"subsets":["cyrillic-ext","vietnamese","latin","cyrillic"],"version":"v10","lastModified":"2019-07-16"},{"family":"Preahvihear","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v11","lastModified":"2019-07-16"},{"family":"Press Start 2P","category":"display","variants":["regular"],"subsets":["cyrillic-ext","latin","latin-ext","greek","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Pridi","category":"serif","variants":["200","300","regular","500","600","700"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Princess Sofia","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Prociono","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Prompt","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-17"},{"family":"Prosto One","category":"display","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Proza Libre","category":"sans-serif","variants":["regular","italic","500","500italic","600","600italic","700","700italic","800","800italic"],"subsets":["latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Public Sans","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900","100italic","200italic","300italic","italic","500italic","600italic","700italic","800italic","900italic"],"subsets":["latin","latin-ext"],"version":"v2","lastModified":"2019-11-13"},{"family":"Puritan","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Purple Purse","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Quando","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Quantico","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Quattrocento","category":"serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Quattrocento Sans","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v12","lastModified":"2019-07-17"},{"family":"Questrial","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-17"},{"family":"Quicksand","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["vietnamese","latin","latin-ext"],"version":"v19","lastModified":"2019-10-22"},{"family":"Quintessential","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Qwigley","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Racing Sans One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Radley","category":"serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v14","lastModified":"2019-07-16"},{"family":"Rajdhani","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Rakkas","category":"display","variants":["regular"],"subsets":["latin","latin-ext","arabic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Raleway","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v14","lastModified":"2019-07-23"},{"family":"Raleway Dots","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Ramabhadra","category":"sans-serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v9","lastModified":"2019-07-16"},{"family":"Ramaraja","category":"serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v4","lastModified":"2019-07-16"},{"family":"Rambla","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Rammetto One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Ranchers","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Rancho","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Ranga","category":"display","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Rasa","category":"serif","variants":["300","regular","500","600","700"],"subsets":["gujarati","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Rationale","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Ravi Prakash","category":"display","variants":["regular"],"subsets":["latin","telugu"],"version":"v6","lastModified":"2019-07-16"},{"family":"Red Hat Display","category":"sans-serif","variants":["regular","italic","500","500italic","700","700italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Red Hat Text","category":"sans-serif","variants":["regular","italic","500","500italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v2","lastModified":"2019-11-05"},{"family":"Redressed","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Reem Kufi","category":"sans-serif","variants":["regular"],"subsets":["latin","arabic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Reenie Beanie","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Revalia","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Rhodium Libre","category":"serif","variants":["regular"],"subsets":["devanagari","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Ribeye","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Ribeye Marrow","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Righteous","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-17"},{"family":"Risque","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Roboto","category":"sans-serif","variants":["100","100italic","300","300italic","regular","italic","500","500italic","700","700italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v20","lastModified":"2019-07-24"},{"family":"Roboto Condensed","category":"sans-serif","variants":["300","300italic","regular","italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v18","lastModified":"2019-07-23"},{"family":"Roboto Mono","category":"monospace","variants":["100","100italic","300","300italic","regular","italic","500","500italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v7","lastModified":"2019-07-22"},{"family":"Roboto Slab","category":"serif","variants":["100","300","regular","700"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v9","lastModified":"2019-07-22"},{"family":"Rochester","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Rock Salt","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Rokkitt","category":"serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v14","lastModified":"2019-10-15"},{"family":"Romanesco","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Ropa Sans","category":"sans-serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Rosario","category":"sans-serif","variants":["300","regular","500","600","700","300italic","italic","500italic","600italic","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v16","lastModified":"2019-10-24"},{"family":"Rosarivo","category":"serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Rouge Script","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Rozha One","category":"serif","variants":["regular"],"subsets":["devanagari","latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Rubik","category":"sans-serif","variants":["300","300italic","regular","italic","500","500italic","700","700italic","900","900italic"],"subsets":["hebrew","latin","latin-ext","cyrillic"],"version":"v9","lastModified":"2019-07-22"},{"family":"Rubik Mono One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Ruda","category":"sans-serif","variants":["regular","700","900"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Rufina","category":"serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Ruge Boogie","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Ruluko","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Rum Raisin","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Ruslan Display","category":"display","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v10","lastModified":"2019-07-16"},{"family":"Russo One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-17"},{"family":"Ruthie","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Rye","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Sacramento","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Sahitya","category":"serif","variants":["regular","700"],"subsets":["devanagari","latin"],"version":"v4","lastModified":"2019-07-16"},{"family":"Sail","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Saira","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Saira Condensed","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Saira Extra Condensed","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Saira Semi Condensed","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Saira Stencil One","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v1","lastModified":"2019-11-05"},{"family":"Salsa","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Sanchez","category":"serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Sancreek","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Sansita","category":"sans-serif","variants":["regular","italic","700","700italic","800","800italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Sarabun","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Sarala","category":"sans-serif","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Sarina","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Sarpanch","category":"sans-serif","variants":["regular","500","600","700","800","900"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Satisfy","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-17"},{"family":"Sawarabi Gothic","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","latin","latin-ext","japanese","cyrillic"],"version":"v8","lastModified":"2019-11-05"},{"family":"Sawarabi Mincho","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext","japanese"],"version":"v10","lastModified":"2019-11-05"},{"family":"Scada","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["cyrillic-ext","latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Scheherazade","category":"serif","variants":["regular","700"],"subsets":["latin","arabic"],"version":"v17","lastModified":"2019-07-16"},{"family":"Schoolbell","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Scope One","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Seaweed Script","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Secular One","category":"sans-serif","variants":["regular"],"subsets":["hebrew","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Sedgwick Ave","category":"handwriting","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Sedgwick Ave Display","category":"handwriting","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Sevillana","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Seymour One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v7","lastModified":"2019-07-16"},{"family":"Shadows Into Light","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-17"},{"family":"Shadows Into Light Two","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Shanti","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Share","category":"display","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Share Tech","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Share Tech Mono","category":"monospace","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Shojumaru","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Short Stack","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Shrikhand","category":"display","variants":["regular"],"subsets":["gujarati","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Siemreap","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v12","lastModified":"2019-07-16"},{"family":"Sigmar One","category":"display","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Signika","category":"sans-serif","variants":["300","regular","600","700"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-17"},{"family":"Signika Negative","category":"sans-serif","variants":["300","regular","600","700"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Simonetta","category":"display","variants":["regular","italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-26"},{"family":"Single Day","category":"display","variants":["regular"],"subsets":["korean"],"version":"v1","lastModified":"2019-07-26"},{"family":"Sintony","category":"sans-serif","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Sirin Stencil","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Six Caps","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Skranji","category":"display","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Slabo 13px","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Slabo 27px","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v6","lastModified":"2019-07-22"},{"family":"Slackey","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Smokum","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Smythe","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Sniglet","category":"display","variants":["regular","800"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Snippet","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Snowburst One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Sofadi One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Sofia","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Song Myung","category":"serif","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Sonsie One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Sorts Mill Goudy","category":"serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Source Code Pro","category":"monospace","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","900","900italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v11","lastModified":"2019-08-22"},{"family":"Source Sans Pro","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","600","600italic","700","700italic","900","900italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v13","lastModified":"2019-07-23"},{"family":"Source Serif Pro","category":"serif","variants":["regular","600","700"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-17"},{"family":"Space Mono","category":"monospace","variants":["regular","italic","700","700italic"],"subsets":["vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Special Elite","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-17"},{"family":"Spectral","category":"serif","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic"],"subsets":["vietnamese","latin","latin-ext","cyrillic"],"version":"v6","lastModified":"2019-07-16"},{"family":"Spectral SC","category":"serif","variants":["200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic"],"subsets":["vietnamese","latin","latin-ext","cyrillic"],"version":"v5","lastModified":"2019-07-16"},{"family":"Spicy Rice","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Spinnaker","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Spirax","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Squada One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Sree Krushnadevaraya","category":"serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v7","lastModified":"2019-07-16"},{"family":"Sriracha","category":"handwriting","variants":["regular"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Srisakdi","category":"display","variants":["regular","700"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Staatliches","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"Stalemate","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Stalinist One","category":"display","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v23","lastModified":"2019-08-26"},{"family":"Stardos Stencil","category":"display","variants":["regular","700"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-26"},{"family":"Stint Ultra Condensed","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Stint Ultra Expanded","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Stoke","category":"serif","variants":["300","regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Strait","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Stylish","category":"sans-serif","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Sue Ellen Francisco","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Suez One","category":"serif","variants":["regular"],"subsets":["hebrew","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Sumana","category":"serif","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Sunflower","category":"sans-serif","variants":["300","500","700"],"subsets":["latin","korean"],"version":"v9","lastModified":"2019-07-16"},{"family":"Sunshiney","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Supermercado One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Sura","category":"serif","variants":["regular","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v4","lastModified":"2019-07-16"},{"family":"Suranna","category":"serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v7","lastModified":"2019-07-16"},{"family":"Suravaram","category":"serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v6","lastModified":"2019-07-16"},{"family":"Suwannaphum","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v13","lastModified":"2019-07-16"},{"family":"Swanky and Moo Moo","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Syncopate","category":"sans-serif","variants":["regular","700"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Tajawal","category":"sans-serif","variants":["200","300","regular","500","700","800","900"],"subsets":["latin","arabic"],"version":"v3","lastModified":"2019-07-16"},{"family":"Tangerine","category":"handwriting","variants":["regular","700"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Taprom","category":"display","variants":["regular"],"subsets":["khmer"],"version":"v11","lastModified":"2019-07-16"},{"family":"Tauri","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Taviraj","category":"serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Teko","category":"sans-serif","variants":["300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v9","lastModified":"2019-07-17"},{"family":"Telex","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Tenali Ramakrishna","category":"sans-serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v6","lastModified":"2019-07-16"},{"family":"Tenor Sans","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-16"},{"family":"Text Me One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Thasadith","category":"sans-serif","variants":["regular","italic","700","700italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v3","lastModified":"2019-11-05"},{"family":"The Girl Next Door","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Tienne","category":"serif","variants":["regular","700","900"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Tillana","category":"handwriting","variants":["regular","500","600","700","800"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Timmana","category":"sans-serif","variants":["regular"],"subsets":["latin","telugu"],"version":"v4","lastModified":"2019-07-16"},{"family":"Tinos","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","vietnamese","hebrew","latin","latin-ext","greek","cyrillic"],"version":"v13","lastModified":"2019-07-17"},{"family":"Titan One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Titillium Web","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","600","600italic","700","700italic","900"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-22"},{"family":"Tomorrow","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v2","lastModified":"2019-11-13"},{"family":"Trade Winds","category":"display","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Trirong","category":"serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["thai","vietnamese","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Trocchi","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Trochut","category":"display","variants":["regular","italic","700"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Trykker","category":"serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Tulpen One","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Turret Road","category":"display","variants":["200","300","regular","500","700","800"],"subsets":["latin","latin-ext"],"version":"v1","lastModified":"2019-09-17"},{"family":"Ubuntu","category":"sans-serif","variants":["300","300italic","regular","italic","500","500italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","latin","latin-ext","greek","cyrillic"],"version":"v14","lastModified":"2019-07-22"},{"family":"Ubuntu Condensed","category":"sans-serif","variants":["regular"],"subsets":["greek-ext","cyrillic-ext","latin","latin-ext","greek","cyrillic"],"version":"v10","lastModified":"2019-07-17"},{"family":"Ubuntu Mono","category":"monospace","variants":["regular","italic","700","700italic"],"subsets":["greek-ext","cyrillic-ext","latin","latin-ext","greek","cyrillic"],"version":"v9","lastModified":"2019-07-16"},{"family":"Ultra","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Uncial Antiqua","category":"display","variants":["regular"],"subsets":["latin"],"version":"v7","lastModified":"2019-07-16"},{"family":"Underdog","category":"display","variants":["regular"],"subsets":["latin","latin-ext","cyrillic"],"version":"v8","lastModified":"2019-07-16"},{"family":"Unica One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"UnifrakturCook","category":"display","variants":["700"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"UnifrakturMaguntia","category":"display","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Unkempt","category":"display","variants":["regular","700"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Unlock","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Unna","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v13","lastModified":"2019-07-16"},{"family":"VT323","category":"monospace","variants":["regular"],"subsets":["vietnamese","latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Vampiro One","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Varela","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v10","lastModified":"2019-07-16"},{"family":"Varela Round","category":"sans-serif","variants":["regular"],"subsets":["vietnamese","hebrew","latin","latin-ext"],"version":"v12","lastModified":"2019-07-17"},{"family":"Vast Shadow","category":"display","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Vesper Libre","category":"serif","variants":["regular","500","700","900"],"subsets":["devanagari","latin","latin-ext"],"version":"v11","lastModified":"2019-07-16"},{"family":"Vibes","category":"display","variants":["regular"],"subsets":["latin","arabic"],"version":"v1","lastModified":"2019-11-05"},{"family":"Vibur","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Vidaloka","category":"serif","variants":["regular"],"subsets":["latin"],"version":"v12","lastModified":"2019-07-16"},{"family":"Viga","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-17"},{"family":"Voces","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Volkhov","category":"serif","variants":["regular","italic","700","700italic"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-17"},{"family":"Vollkorn","category":"serif","variants":["regular","italic","600","600italic","700","700italic","900","900italic"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","greek","cyrillic"],"version":"v10","lastModified":"2019-07-17"},{"family":"Vollkorn SC","category":"serif","variants":["regular","600","700","900"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v3","lastModified":"2019-07-16"},{"family":"Voltaire","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Waiting for the Sunrise","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Wallpoet","category":"display","variants":["regular"],"subsets":["latin"],"version":"v11","lastModified":"2019-07-16"},{"family":"Walter Turncoat","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Warnes","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-16"},{"family":"Wellfleet","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"},{"family":"Wendy One","category":"sans-serif","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16"},{"family":"Wire One","category":"sans-serif","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Work Sans","category":"sans-serif","variants":["100","200","300","regular","500","600","700","800","900"],"subsets":["latin","latin-ext"],"version":"v5","lastModified":"2019-07-22"},{"family":"Yanone Kaffeesatz","category":"sans-serif","variants":["200","300","regular","700"],"subsets":["vietnamese","latin","latin-ext","cyrillic"],"version":"v11","lastModified":"2019-07-17"},{"family":"Yantramanav","category":"sans-serif","variants":["100","300","regular","500","700","900"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"Yatra One","category":"display","variants":["regular"],"subsets":["devanagari","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16"},{"family":"Yellowtail","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v10","lastModified":"2019-07-16"},{"family":"Yeon Sung","category":"display","variants":["regular"],"subsets":["latin","korean"],"version":"v8","lastModified":"2019-07-16"},{"family":"Yeseva One","category":"display","variants":["regular"],"subsets":["cyrillic-ext","vietnamese","latin","latin-ext","cyrillic"],"version":"v14","lastModified":"2019-07-16"},{"family":"Yesteryear","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v8","lastModified":"2019-07-16"},{"family":"Yrsa","category":"serif","variants":["300","regular","500","600","700"],"subsets":["latin","latin-ext"],"version":"v5","lastModified":"2019-07-16"},{"family":"ZCOOL KuaiLe","category":"display","variants":["regular"],"subsets":["latin","chinese-simplified"],"version":"v5","lastModified":"2019-11-05"},{"family":"ZCOOL QingKe HuangYou","category":"display","variants":["regular"],"subsets":["latin","chinese-simplified"],"version":"v5","lastModified":"2019-11-05"},{"family":"ZCOOL XiaoWei","category":"serif","variants":["regular"],"subsets":["latin","chinese-simplified"],"version":"v5","lastModified":"2019-11-05"},{"family":"Zeyada","category":"handwriting","variants":["regular"],"subsets":["latin"],"version":"v9","lastModified":"2019-07-16"},{"family":"Zhi Mang Xing","category":"handwriting","variants":["regular"],"subsets":["latin","chinese-simplified"],"version":"v5","lastModified":"2019-11-05"},{"family":"Zilla Slab","category":"serif","variants":["300","300italic","regular","italic","500","500italic","600","600italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v5","lastModified":"2019-07-17"},{"family":"Zilla Slab Highlight","category":"display","variants":["regular","700"],"subsets":["latin","latin-ext"],"version":"v7","lastModified":"2019-07-16"}]';
	}

	/**
	 * Modula Placeholders
	 *
	 * @return mixed|void
	 * @since 2.3.2
	 */
	public static function modula_albums_placeholders() {

		return apply_filters( 'modula_albums_placeholders', array() );
	}

	/**
	 * Placeholders real/front value
	 *
	 * @param $value
	 * @param $obj
	 *
	 * @return string|string[]
	 * @since 2.3.2
	 */
	public static function modula_albums_placeholders_value( $value, $obj ) {

		$values = apply_filters(
			'modula_albums_placeholder_values',
			array(
				'setting' => array(),
				'front'   => array(),
			),
			$obj
		);

		return str_replace( $values['setting'], $values['front'], $value );
	}

	/**
	 * Defaults from the pro version
	 *
	 * @param array $defaults Array of default settings.
	 *
	 * @return array
	 * @since 2.6.5 - moved from class-modula-pro-settings.php here in order to preserve the default settings in front.
	 */
	public static function default_settings( $defaults ) {

		$defaults['maxImagesCount']              = 0;
		$defaults['maxImagesCount_mobile']       = 0;
		$defaults['showAllOnLightbox']           = 0;
		$defaults['filters']                     = array( '' );
		$defaults['filterClick']                 = 0;
		$defaults['allFilterLabel']              = esc_html__( 'All', 'modula-pro' );
		$defaults['dropdownFilters']             = 0;
		$defaults['loadedRotate']                = 0;
		$defaults['loadedHSlide']                = 0;
		$defaults['loadedVSlide']                = 0;
		$defaults['hoverColor']                  = '#fff';
		$defaults['uploadCursor']                = 0;
		$defaults['hoverOpacity']                = 50;
		$defaults['hideAllFilter']               = 0;
		$defaults['enableCollapsibleFilters']    = 0;
		$defaults['enableMobileDropdownFilters'] = 0;
		$defaults['filterPositioning']           = 'top';
		$defaults['filterTextAlignment']         = 'none';
		$defaults['defaultActiveFilter']         = 'All';
		$defaults['filterLinkColor']             = '';
		$defaults['filterLinkHoverColor']        = '';
		$defaults['filterStyle']                 = 'default';
		$defaults['showTitleLightbox']           = 0;
		$defaults['showCaptionLightbox']         = 1;
		$defaults['captionPosition']             = 'center';
		$defaults['show_gallery_title']          = 0;
		$defaults['gallery_title_type']          = 'p';
		$defaults['titleFontFamily']             = 'Default';
		$defaults['titleFontWeight']             = 'normal';
		$defaults['captionsFontFamily']          = 'Default';
		$defaults['captionFontWeight']           = 'normal';
		$defaults['collapsibleActionText']       = __( 'Filter by', 'modula-pro' );
		$defaults['open_Lightbox_on']            = 'both';
		$defaults['loop_lightbox']               = 0;
		$defaults['doubleClick']                 = 0;
		$defaults['mobile_caption_copy']         = 1;
		$defaults['lightbox_background_color']   = 'rgba(30,30,30,.9)';
		$defaults['lightbox_keyboard']           = 1;
		$defaults['lightbox_wheel']              = 0;
		$defaults['lightbox_toolbar']            = 1;
		$defaults['lightbox_close']              = 1;
		$defaults['lightbox_download']           = 0;
		$defaults['lightbox_thumbs']             = 0;
		$defaults['lightbox_zoom']               = 0;
		$defaults['lightbox_share']              = 0;
		$defaults['lightbox_facebook']           = 0;
		$defaults['lightbox_twitter']            = 0;
		$defaults['lightbox_whatsapp']           = 0;
		$defaults['lightbox_pinterest']          = 0;
		$defaults['lightbox_linkedin']           = 0;
		$defaults['lightbox_email']              = 0;
		$defaults['lightboxEmailSubject']        = esc_html__( 'Check out this awesome image !!', 'modula-pro' );
		$defaults['lightboxEmailMessage']        = esc_html__( 'Here is the link to the image : %%image_link%% and this is the link to the gallery : %%gallery_link%% ', 'modula-pro' );
		$defaults['lightbox_infobar']            = 1;
		$defaults['lightbox_dblclickSlide']      = 0;
		$defaults['lightbox_clickSlide']         = 0;
		$defaults['lightbox_animationEffect']    = false;
		$defaults['lightbox_transitionEffect']   = 'fade';
		$defaults['lightbox_touch']              = 1;
		$defaults['lightbox_thumbsAutoStart']    = 0;

		if ( ! isset( $defaults['cursor'] ) ) {
			$defaults['cursor'] = 'magnifying-glass';
		}

		return $defaults;
	}
}
