<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Lightbox_Enhancer {
	public function __construct() {
		add_filter( 'modula_fancybox_options', array( $this, 'output_lightbox_options' ), 10, 2 );
		add_filter( 'modula_fancybox_options', array( $this, 'output_lightbox_close_button' ), 9999, 2 );
		add_action( 'modula_extra_scripts', array( $this, 'check_for_fonts' ) );

		add_filter( 'modula_shortcode_item_data', array( $this, 'pro_extra_item_data' ), 16, 3 );

		add_action( 'modula_extra_scripts', array( $this, 'output_extra_effects_scripts' ) );

		add_action( 'modula_item_after_image', array( $this, 'extra_effects_extra_elements' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'preview_extra_effects_scripts' ) );
	}

	public function output_lightbox_options( $fancybox_options, $settings ) {

		$fancybox_options['buttons'] = array();

		if ( isset( $settings['loop_lightbox'] ) && 1 === absint( $settings['loop_lightbox'] ) ) {
			$fancybox_options['loop'] = true;
		}

		if ( isset( $fancybox_options['clickContent'] ) ) {
			unset( $fancybox_options['clickContent'] );
		}

		if ( isset( $settings['lightbox_toolbar'] ) && 1 === absint( $settings['lightbox_toolbar'] ) ) {
			$fancybox_options['toolbar'] = true;
		} else {
			$fancybox_options['toolbar'] = false;
		}

		if ( isset( $settings['lightbox_infobar'] ) && 1 === absint( $settings['lightbox_infobar'] ) ) {
			$fancybox_options['infobar'] = true;
		} else {
			$fancybox_options['infobar'] = false;
		}

		// Add all buttons.
		if ( isset( $settings['lightbox_zoom'] ) && 1 === absint( $settings['lightbox_zoom'] ) ) {
			$fancybox_options['buttons'][] = 'zoom';
		}

		if ( isset( $settings['lightbox_share'] ) && 1 === absint( $settings['lightbox_share'] ) ) {
			$fancybox_options['buttons'][] = 'share';

			if ( isset( $settings['lightbox_facebook'] ) && 1 === absint( $settings['lightbox_facebook'] ) ) {
				$fancybox_options['modulaShare'][] = 'facebook';
			}

			if ( isset( $settings['lightbox_twitter'] ) && 1 === absint( $settings['lightbox_twitter'] ) ) {
				$fancybox_options['modulaShare'][] = 'twitter';
			}

			if ( isset( $settings['lightbox_whatsapp'] ) && 1 === absint( $settings['lightbox_whatsapp'] ) ) {
				$fancybox_options['modulaShare'][] = 'whatsapp';
			}

			if ( isset( $settings['lightbox_linkedin'] ) && 1 === absint( $settings['lightbox_linkedin'] ) ) {
				$fancybox_options['modulaShare'][] = 'linkedin';
			}

			if ( isset( $settings['lightbox_pinterest'] ) && 1 === absint( $settings['lightbox_pinterest'] ) ) {
				$fancybox_options['modulaShare'][] = 'pinterest';
			}

			if ( isset( $settings['lightbox_email'] ) && 1 === absint( $settings['lightbox_email'] ) ) {
				$fancybox_options['modulaShare'][] = 'email';
			}

			if ( isset( $settings['lightboxEmailSubject'] ) ) {
				$fancybox_options['lightboxEmailSubject'] = esc_html( $settings['lightboxEmailSubject'] );
			} else {
				$fancybox_options['lightboxEmailSubject'] = esc_html__( 'Check out this awesome image !!', 'modula-pro' );
			}

			if ( isset( $settings['lightboxEmailMessage'] ) ) {
				$fancybox_options['lightboxEmailMessage'] = esc_html( $settings['lightboxEmailMessage'] );
			} else {
				$fancybox_options['lightboxEmailMessage'] = esc_html__( 'Here is the link to the image : %%image_link%% and this is the link to the gallery : %%gallery_link%% ', 'modula-pro' );
			}

			if ( isset( $settings['galleryMessage'] ) ) {
				$fancybox_options['messageGallery'] = $settings['galleryMessage'];
			} else {
				$fancybox_options['messageGallery'] = esc_html__( 'Here is the link to the gallery :', 'modula-pro' );
			}
		}

		if ( isset( $settings['lightbox_download'] ) && 1 === absint( $settings['lightbox_download'] ) ) {
			$fancybox_options['buttons'][] = 'download';
		}

		if ( isset( $settings['lightbox_thumbs'] ) && 1 === absint( $settings['lightbox_thumbs'] ) ) {
			$fancybox_options['buttons'][] = 'thumbs';
		}

		if ( isset( $settings['lightbox_keyboard'] ) && 1 === absint( $settings['lightbox_keyboard'] ) ) {
			$fancybox_options['keyboard'] = true;
		} else {
			$fancybox_options['keyboard'] = false;
		}

		if ( isset( $settings['lightbox_wheel'] ) && 1 === absint( $settings['lightbox_wheel'] ) ) {
			$fancybox_options['wheel'] = true;
		} else {
			$fancybox_options['wheel'] = false;
		}

		if ( isset( $settings['lightbox_clickSlide'] ) && 1 === absint( $settings['lightbox_clickSlide'] ) ) {
			$fancybox_options['clickSlide'] = 'close';
		}

		if ( isset( $settings['lightbox_touch'] ) && 1 === absint( $settings['lightbox_touch'] ) ) {
			$fancybox_options['touch'] = array(
				'vertical' => true,
				'momentum' => true,
			);
		}

		if ( isset( $settings['lightbox_thumbsAutoStart'] ) && 1 === absint( $settings['lightbox_thumbsAutoStart'] ) ) {
			$fancybox_options['thumbs']['autoStart'] = true;
		} else {
			$fancybox_options['thumbs']['autoStart'] = false;
		}

		if ( isset( $settings['lightbox_animationEffect'] ) && 'false' !== $settings['lightbox_animationEffect'] ) {
			$fancybox_options['animationEffect'] = esc_html( $settings['lightbox_animationEffect'] );
		} else {
			$fancybox_options['animationEffect'] = false;
		}
		if ( isset( $settings['lightbox_animationDuration'] ) ) {
			$fancybox_options['animationDuration'] = (int) $settings['lightbox_animationDuration'];
		}

		if ( isset( $settings['lightbox_transitionEffect'] ) ) {
			$fancybox_options['transitionEffect'] = esc_html( $settings['lightbox_transitionEffect'] );
		}

		if ( isset( $settings['lightbox_animationEffect'] ) ) {
			$fancybox_options['animationEffect'] = esc_html( $settings['lightbox_animationEffect'] );
		}

		return $fancybox_options;
	}

	public function output_lightbox_close_button( $fancybox_options, $settings ) {

		if ( isset( $settings['lightbox_close'] ) && 1 === absint( $settings['lightbox_close'] ) ) {
			$fancybox_options['buttons'][] = 'close';
		}

		return $fancybox_options;
	}

	public function check_for_fonts( $settings ) {

		if ( ( isset( $settings['hide_title'] ) && 1 === absint( $settings['hide_title'] ) ) && ( isset( $settings['hide_description'] ) && 1 === absint( $settings['hide_description'] ) ) ) {
			return;
		}

		if ( ! isset( $settings['captionsFontFamily'] ) || ! isset( $settings['titleFontFamily'] ) ) {
			return;
		}

		if ( 'Default' === $settings['captionsFontFamily'] && 'Default' === $settings['titleFontFamily'] ) {
			return;
		}

		$fonts = array();

		if ( 'Default' !== $settings['titleFontFamily'] ) {
			if ( 'normal' === $settings['titleFontWeight'] ) {
				$fonts[ $settings['titleFontFamily'] ] = array( 300, 400, 700 );
			} else {
				$fonts[ $settings['titleFontFamily'] ] = array( intval( $settings['titleFontWeight'] ) );
			}
		}

		if ( 'Default' !== $settings['captionsFontFamily'] ) {
			if ( 'normal' === $settings['captionFontWeight'] ) {
				$fonts_weights = array( 300, 400, 700 );
			} else {
				$fonts_weights = array( intval( $settings['captionFontWeight'] ) );
			}

			if ( isset( $fonts[ $settings['captionsFontFamily'] ] ) ) {
				$fonts[ $settings['captionsFontFamily'] ] = array_merge( $fonts[ $settings['captionsFontFamily'] ], $fonts_weights );
			} else {
				$fonts[ $settings['captionsFontFamily'] ] = $fonts_weights;
			}
		}

		if ( empty( $fonts ) ) {
			return;
		}

		$new_fonts = array();
		foreach ( $fonts as $font => $weights ) {
			$font_name   = str_replace( ' ', '+', $font );
			$new_fonts[] = $font_name . ':' . implode( ',', array_unique( $weights ) );
		}

		$fonts_string = implode( '|', $new_fonts );
		$font_url     = 'https://fonts.googleapis.com/css?family=' . $fonts_string . '&display=swap';
		wp_enqueue_style( 'modula-pro-font', $font_url, array(), MODULA_PRO_VERSION );
	}

	public function pro_extra_item_data( $item_data, $image, $settings ) {

		/**
		 * @since 2.2.2 after fancyBox update to v3.5.7
		 */
		// Check if not set prior by Modula Speedup with a highest priority filter
		if ( ! isset( $item_data['link_attributes']['data-thumb'] ) ) {
			$thumb = wp_get_attachment_image_src( $image['id'], 'thumbnail' );
			if ( $thumb ) {
				$item_data['link_attributes']['data-thumb'] = $thumb[0];
			} else {
				$item_data['link_attributes']['data-thumb'] = $item_data['img_attributes']['data-src'];
			}
		}

		/**
		 * @since 2.3.0
		 */
		if ( isset( $item_data['link_attributes']['data-caption'] ) ) {
			$caption = '';

			if ( isset( $image['description'] ) && '' !== $image['description'] ) {
				$caption = $image['description'];
			} elseif ( wp_get_attachment_image_src( $image['id'] ) ) {
				$caption = wp_get_attachment_caption( $image['id'] );
			}

			$show_title   = ( isset( $settings['showTitleLightbox'] ) && 1 === absint( $settings['showTitleLightbox'] ) ) && ( ! isset( $image['hide_title'] ) || 1 !== absint( $image['hide_title'] ) );
			$show_caption = ( isset( $settings['showCaptionLightbox'] ) && 1 === absint( $settings['showCaptionLightbox'] ) );

			if ( $show_title && $show_caption ) {
				$item_data['link_attributes']['data-caption'] = esc_attr( '<span class="modula-caption-title">' . $image['title'] . '</span><br><span class="modula-caption-description">' . $caption . '</span>' );
			} elseif ( $show_title && ! $show_caption ) {
				$item_data['link_attributes']['data-caption'] = esc_attr( '<span class="modula-caption-title">' . $image['title'] . '</span>' );
			} elseif ( ! $show_title && $show_caption ) {
				$item_data['link_attributes']['data-caption'] = esc_attr( '<span class="modula-caption-description">' . $caption . '</span>' );
			} else {
				$item_data['link_attributes']['data-caption'] = '';
			}
		}

		if ( isset( $image['link'] ) && '' !== $image['link'] ) {
			unset( $item_data['link_attributes']['data-caption'] );
			unset( $item_data['link_attributes']['rel'] );
			unset( $item_data['link_attributes']['data-fancybox'] );
			unset( $item_data['link_attributes']['aria-label'] );
			unset( $item_data['link_attributes']['title'] );

			$item_data['link_attributes']['href'] = $image['link'];

			if ( isset( $image['target'] ) && 1 === $image['target'] ) {
				$item_data['link_attributes']['target'] = '_blank';
			}

			$item_data['link_attributes']['class'][] = 'modula-simple-link';
			$item_data['item_classes'][]             = 'modula-simple-link';
		}

		return $item_data;
	}

	public function output_extra_effects_scripts( $settings ) {

		$effect      = $settings['effect'];
		$tilt_effect = array( 'tilt_1', 'tilt_2', 'tilt_3', 'tilt_4', 'tilt_5', 'tilt_6', 'tilt_7', 'tilt_8' );

		if ( in_array( $effect, $tilt_effect, true ) ) {
			wp_enqueue_script( 'modula-pro-tilt' );
		}
	}

	public function preview_extra_effects_scripts() {

		$current_screen = get_current_screen();

		// Register and Enqueue scripts only for Modula Gallery posts
		if ( 'modula-gallery' === $current_screen->id ) {

			// Modula Pro scripts used for Tilt Hover Effects
			wp_register_script( 'modula-pro-tilt', MODULA_PRO_URL . 'assets/js/misc/modula-pro-tilt.js', array( 'jquery' ), MODULA_PRO_VERSION, true );
			wp_enqueue_script( 'modula-pro-tilt' );
		}
	}

	public function extra_effects_extra_elements( $data ) {

		if ( count( $data->item_classes ) > 1 ) {
			$hover_effect  = $data->item_classes[1];
			$effect        = explode( '-', $hover_effect );
			$effect_array  = array( 'tilt_1', 'tilt_2', 'tilt_3', 'tilt_4', 'tilt_5', 'tilt_6', 'tilt_7', 'tilt_8' );
			$overlay_array = array( 'tilt_2', 'tilt_3', 'tilt_4', 'tilt_5', 'tilt_6', 'tilt_7', 'tilt_8' );
			$svg_array     = array( 'tilt_1', 'tilt_2', 'tilt_4', 'tilt_5', 'tilt_6', 'tilt_7', 'tilt_8' );
			if ( in_array( $effect[1], $effect_array, true ) ) {
				echo '<div class="tilter__deco tilter__deco--shine"><div></div></div>';

				if ( in_array( $effect[1], $overlay_array, true ) ) {
					echo '<div class="tilter__deco tilter__deco--overlay"></div>';
				}

				if ( in_array( $effect[1], $svg_array, true ) ) {
					echo '<div class="tilter__deco tilter__deco--lines"></div>';
				}
			}
		}
	}
}
