<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Link_Shortcode {
	public function __construct() {
		$cpt_name = apply_filters( 'modula_cpt_name', 'modula-gallery' );
		add_shortcode( 'modula-link', array( $this, 'link_shortcode' ) );
		add_action( "manage_{$cpt_name}_posts_custom_column", array( $this, 'output_column' ), 20, 2 );
		add_action( 'modula_admin_after_shortcode_metabox', array( $this, 'output_link_shortcode' ) );
	}

	public function output_column( $column, $post_id ) {

		if ( 'shortcode' === $column ) {
			$shortcode = '[modula-link id="' . $post_id . '"]' . esc_html__( 'Click here', 'modula-pro' ) . '[/modula-link]';
			echo '<div class="modula-copy-shortcode">';
			echo '<input type="text" value="' . esc_attr( $shortcode ) . '"  onclick="select()" readonly>';
			echo '<a href="#" title="' . esc_attr__( 'Copy shortcode', 'modula-pro' ) . '" class="copy-modula-shortcode button button-primary dashicons dashicons-format-gallery" style="width:40px;"></a><span></span>';
			echo '</div>';
		}
	}

	public function output_link_shortcode( $post ) {
		$shortcode = '[modula-link id="' . $post->ID . '"]' . esc_html__( 'Click here', 'modula-pro' ) . '[/modula-link]';
		echo '<div class="modula-copy-shortcode">';
		echo '<input type="text" value="' . esc_attr( $shortcode ) . '"  onclick="select()" readonly>';
		echo '<a href="#" title="' . esc_attr__( 'Copy shortcode', 'modula-pro' ) . '" class="copy-modula-shortcode button button-primary dashicons dashicons-format-gallery" style="width:40px;"></a><span></span>';
		echo '<p>' . sprintf(
			// translators: %1$s: opening link tag, %2$s: closing link tag
			esc_html__( 'You can use this to display your newly created gallery by clicking on a %1$s link or image %2$s ', 'modula-pro' ),
			'<u>',
			'</u>'
		) . '</p>';
		echo '</div>';
	}


	public function link_shortcode( $atts, $content = null ) {

		$default_atts = array(
			'id' => false,
		);

		$atts = wp_parse_args( $atts, $default_atts );

		if ( '' === $atts['id'] || ! $atts['id'] ) {
			return esc_html( 'Gallery ID not found !' );
		}

		$gallery = get_post( absint( $atts['id'] ) );

		if ( 'modula-gallery' !== get_post_type( $gallery ) ) {
			return esc_html__( 'Given ID doesn\'t belong to a Modula Gallery!', 'modula-pro' );
		}

		$script_manager = false;
		if ( class_exists( 'Modula_Script_Manager' ) ) {
			$script_manager = Modula_Script_Manager::get_instance();
		}

		$settings = get_post_meta( $atts['id'], 'modula-settings', true );
		$defaults = Modula_CPT_Fields_Helper::get_defaults();
		$settings = wp_parse_args( $settings, $defaults );

		// Need this for Modula Deeplink. Added the 'jtg-' string to comply with the search and replace
		$settings['gallery_id'] = 'jtg-link-' . $atts['id'];

		$pre_gallery_html = apply_filters( 'modula_pre_output_filter_check', false, $settings, $gallery );

		if ( false !== $pre_gallery_html ) {

			// If there is HTML, then we stop trying to display the gallery and return THAT HTML.
			$pre_output = apply_filters( 'modula_pre_output_filter', '', $settings, $gallery );
			return $pre_output;
		}

		$fancybox_options = Modula_Helper::lightbox_default_options();

		$fancybox_options = apply_filters( 'modula_fancybox_options', $fancybox_options, $settings );

		// Enqueue only after we found a gallery
		$necessary_scripts = apply_filters( 'modula_link_necessary_scripts', array( 'modula-fancybox', 'modula-link-shortcode' ), $settings );

		$necessary_styles = apply_filters( 'modula_link_necessary_styles', array( 'modula-fancybox', 'modula' ), $settings );

		if ( ! empty( $necessary_scripts ) ) {
			if ( ! $script_manager ) {
				foreach ( $necessary_scripts as $script ) {
					wp_enqueue_script( $script );
				}
			} else {
				$script_manager->add_scripts( $necessary_scripts );
			}
		}

		if ( ! empty( $necessary_styles ) ) {
			foreach ( $necessary_styles as $style ) {
				wp_enqueue_style( $style );
			}
		}

		do_action( 'modula_link_extra_scripts', $settings );

		$images       = get_post_meta( $atts['id'], 'modula-images', true );
		$images_array = array();

		if ( ! empty( $images ) ) {
			foreach ( $images as $image ) {
				$image_url = wp_get_attachment_image_src( $image['id'], 'full' );
				if ( $image_url && isset( $image_url[0] ) ) {
					$image_url = $image_url[0];
				}

				$image_thumb = wp_get_attachment_image_src( $image['id'] );
				if ( $image_thumb && isset( $image_thumb[0] ) ) {
					$image_thumb = $image_thumb[0];
				}

				$new_image = apply_filters(
					'modula_link_item',
					array(
						'src'  => $image_url,
						'opts' => array(
							'caption'  => $this->check_lightbox_link_title_caption( $settings, $image['title'], $image['description'] ),
							'thumb'    => $image_thumb,
							'image_id' => $image['id'],
						),
					),
					$image,
					$atts['id'],
					$settings
				);

				$images_array[] = $new_image;
			}
		}
		ob_start();

		$not_allowed_lightbox = array( 'no-link', 'direct', 'attachment-page', 'external-url' );
		$not_allowed_types    = array( 'slider' );

		$lightbox = 'true';

		if ( in_array( $settings['lightbox'], $not_allowed_lightbox, true ) || in_array( $settings['type'], $not_allowed_types, true ) ) {
			$lightbox = 'false';
		}

		if ( isset( $settings['mobile_caption_copy'] ) && 1 === absint( $settings['mobile_caption_copy'] ) && wp_is_mobile() ) {
			$fancybox_options['copyCaptionMobile'] = 1;
		}

		$link_js_config = apply_filters(
			'modula_link_gallery_settings',
			array(
				'lightbox'     => $lightbox,
				'lightboxOpts' => $fancybox_options,
			),
			$settings
		);

		//phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo $this->modula_link_css( $atts['id'], $settings );

		echo '<a id="' . esc_attr( $settings['gallery_id'] ) . '" data-images="' . esc_attr( wp_json_encode( $images_array ) ) . '" data-config="' . esc_attr( wp_json_encode( $link_js_config ) ) . '" class="jtg-' . esc_attr( $atts['id'] ) . ' modula-link" href="#">' . do_shortcode( $content ) . '</a>';

		$html = ob_get_clean();

		return $html;
	}

	public function modula_link_css( $gallery_id, $settings ) {

		$css = '<style>';

		if ( isset( $settings['lightbox_background_color'] ) && '' !== $settings['lightbox_background_color'] ) {
			$css .= '.modula-fancybox-container.modula-lightbox-jtg-link-' . $gallery_id . ' {--fancybox-bg:' . modula_pro_sanitize_color( $settings['lightbox_background_color'] ) . ';--fancybox-opacity:1 !important;}';
		}

		if ( ! isset( $settings['show_navigation'] ) || 1 !== absint( $settings['show_navigation'] ) ) {
			$css .= 'html body .modula-fancybox-container.modula-lightbox-jtg-link-' . $gallery_id . ' .fancybox__nav{display:none}';
		}

		if ( isset( $settings['captionPosition'] ) ) {
			$css .= '.modula-fancybox-container.modula-lightbox-jtg-link-' . $gallery_id . ' .modula-fancybox-caption .modula-fancybox-caption__body, .modula-fancybox-container.modula-lightbox-jtg-link-' . $gallery_id . ' .modula-fancybox-caption .modula-fancybox-caption__body p {text-align:' . esc_attr( $settings['captionPosition'] ) . '}';
		}

		if ( strlen( $settings['style'] ) ) {
			$css .= esc_html( $settings['style'] );
		}

		$css = apply_filters( 'modula_link_shortcode_css', $css, $gallery_id, $settings );

		$css .= '</style>';

		return $css;
	}

	public function check_lightbox_link_title_caption( $settings, $title, $caption ) {

		$html = '';
		if ( 1 === absint( $settings['showTitleLightbox'] ) ) {
			$html .= "<p> {$title} </p> ";
		}
		if ( 1 === absint( $settings['showCaptionLightbox'] ) ) {
			$html .= "<p> {$caption} </p> ";
		}
		return $html;
	}
}
