<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Notices {
	public $lite_notice = false;

	public function __construct() {
		add_action( 'admin_notices', array( $this, 'license_notices' ), 99 );
		add_action( 'admin_notices', array( $this, 'lite_notice' ), 99 );
	}

	public function display_lite_notice() {
		$this->lite_notice = true;
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_lite_scripts' ) );
	}

	public function license_notices() {
		if ( ! get_option( 'modula_pro_license_status', false ) || 'valid' !== get_option( 'modula_pro_license_status', false )->license ) {
			$message = sprintf(
				// translators: %1$s: Modula Pro, %2$s: strong tag, %3$s: a tag, %4$s: a tag
				esc_html__( '%1$sModula Pro%2$s: No valid license key has been entered, so any installed Modula Addons have been turned off. %3$sPlease click here to enter your license key and begin receiving automatic updates.%4$s', 'modula-pro' ),
				'<strong>',
				'</strong>',
				'<a href="' . admin_url( 'edit.php?post_type=modula-gallery&page=modula&modula-tab=licenses' ) . '">',
				'</a>'
			);

			$this->display_inline_notice( 'warning-license-key', false, $message, 'error ', DAY_IN_SECONDS );
		}
	}

	public function display_inline_notice( $notice, $title, $message, $type = 'success', $button_text = '', $button_url = '', $is_dismissible = true, $seconds = false ) {

		// Display inline notice.
		?>
		<div class="updated modula-notice <?php echo sanitize_html_class( $type . ( $is_dismissible ? ' -is-dismissible' : '' ) ); ?>" data-seconds="<?php echo esc_attr( $seconds ); ?>" data-notice="<?php echo esc_attr( $notice ); ?>">
			<?php
			// Message.
			if ( ! empty( $message ) ) {
				?>
				<p><?php echo $message; // @codingStandardsIgnoreLine 
				?>
				</p>
				<?php
			}
			?>
		</div>
		<?php
	}

	public function lite_notice() {
		if ( ! $this->lite_notice ) {
			return;
		}

		$check = array(
			'installed' => Modula_Pro_Helper::check_plugin_is_installed( 'modula-best-grid-gallery' ),
			'active'    => Modula_Pro_Helper::check_plugin_is_active( 'modula-best-grid-gallery' ),
		);

		if ( ! $check['installed'] ) {
			$label  = esc_html__( 'Install & Activate: Modula Lite', 'modula-pro' );
			$action = 'install';
			$url    = '#';
		} else {
			$label  = esc_html__( 'Activate: Modula Lite', 'modula-pro' );
			$action = 'activate';
			$url    = add_query_arg(
				array(
					'action'        => 'activate',
					'plugin'        => rawurlencode( Modula_Pro_Helper::_get_plugin_basename_from_slug( 'modula-best-grid-gallery' ) ),
					'plugin_status' => 'all',
					'paged'         => '1',
					'_wpnonce'      => wp_create_nonce( 'activate-plugin_' . Modula_Pro_Helper::_get_plugin_basename_from_slug( 'modula-best-grid-gallery' ) ),
				),
				admin_url( 'plugins.php' )
			);
		}

		echo '<div id="modula-install-lite" class="notice">';
		echo '<h1>' . esc_html__( 'Install & Activate Modula Lite', 'modula-pro' ) . '</h1>';
		echo '<h4>' . esc_html__( 'In order for Modula PRO to work properly, you\'ll also need to have Modula Lite installed & activated', 'modula-pro' ) . '</h4>';
		echo '<a href="' . esc_url( $url ) . '" data-action="' . esc_attr( $action ) . '" class="button button-primary button-hero" id="install-modula-lite">' . esc_html( $label ) . '</a>';
		echo '</div>';
	}

	public function admin_lite_scripts() {
		wp_enqueue_style( 'modula-pro-install-lite', MODULA_PRO_URL . 'assets/js/misc/install-lite.css', array(), MODULA_PRO_VERSION );
		wp_enqueue_script( 'modula-install-lite', MODULA_PRO_URL . 'assets/js/misc/install-lite.js', array( 'jquery', 'updates' ), MODULA_PRO_VERSION, true );
	}
}
