<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Scripts {
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'register_gallery_scripts' ) );
		add_filter( 'modula_necessary_scripts', array( $this, 'enqueue_necessary_scripts' ) );
		add_filter( 'modula_necessary_styles', array( $this, 'modula_necessary_styles' ), 10, 2 );
	}

	public function register_gallery_scripts() {
		// Modula PRO
		wp_register_style( 'modula-pro-effects', MODULA_PRO_URL . 'assets/js/misc/effects.css', array(), MODULA_PRO_VERSION );
		wp_register_script( 'modula-pro', MODULA_PRO_URL . 'assets/js/misc/modula-pro.js', array( 'jquery' ), MODULA_PRO_VERSION, true );

		// Modula Pro scripts used for Tilt Hover Effects
		wp_register_script( 'modula-pro-tilt', MODULA_PRO_URL . 'assets/js/misc/modula-pro-tilt.js', array( 'jquery' ), MODULA_PRO_VERSION, true );

		// Modula Link script
		wp_register_script( 'modula-link-shortcode', MODULA_PRO_URL . 'assets/js/misc/modula-link.js', array( 'jquery' ), MODULA_PRO_VERSION, true );

		// Modula bnb
		wp_register_style( 'modula-pro-bnb', MODULA_PRO_URL . 'assets/js/misc/modula-pro.css', array(), MODULA_PRO_VERSION );
	}

	public function enqueue_necessary_scripts( $scripts ) {
		$scripts[] = 'modula-pro';
		return $scripts;
	}

	public function modula_necessary_styles( $styles, $settings ) {
		// Search for css for effect in lite and remove it.
		$lite_effects = array_search( 'modula-effects', $styles, true );
		if ( false !== $lite_effects ) {
			unset( $styles[ $lite_effects ] );
		}

		$styles[] = 'modula-pro';
		$styles[] = 'modula-pro-effects';

		if ( isset( $settings['type'] ) && 'bnb' === $settings['type'] ) {
			$styles[] = 'modula-pro-bnb';
		}

		return $styles;
	}
}
