<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Templates {
	public function __construct() {
		add_filter( 'modula_template_paths', array( $this, 'add_templates_path' ), 20 );

		add_filter( 'modula_gallery_template_data', array( $this, 'filter_class_helper' ), 20, 1 );

		add_action( 'modula_shortcode_before_items', array( $this, 'gallery_title' ), 5 );
	}

	public function add_templates_path( $paths ) {
		$paths[50] = trailingslashit( MODULA_PRO_PATH ) . '/includes/templates';
		return $paths;
	}

	public function filter_class_helper( $template_data ) {

		if ( isset( $template_data['settings']['filters'] ) && '' !== $template_data['settings']['filters'] ) {
			if ( isset( $template_data['settings']['filterPositioning'] ) ) {
				$horizontal_position = array( 'top', 'bottom', 'top_bottom' );
				$vertical_position   = array( 'left', 'right', 'left_right' );

				if ( in_array( $template_data['settings']['filterPositioning'], $vertical_position, true ) && ! empty( Modula_Pro_Helper::remove_empty_items( $template_data['settings']['filters'] ) ) ) {
					$template_data['gallery_container']['class'][] = 'vertical-filters';
				}

				if ( in_array( $template_data['settings']['filterPositioning'], $horizontal_position, true ) && ! empty( Modula_Pro_Helper::remove_empty_items( $template_data['settings']['filters'] ) ) ) {
					$template_data['gallery_container']['class'][] = 'horizontal-filters';
				}
			}
		}

		return $template_data;
	}

	public function gallery_title( $settings ) {

		$title = get_the_title( explode( '-', $settings['gallery_id'] )[1] );
		if ( isset( $settings['show_gallery_title'] ) && 1 === absint( $settings['show_gallery_title'] ) ) {
			echo ' <' . esc_attr( $settings['gallery_title_type'] ) . " class='modula-gallery-title'> " . esc_html( $title ) . ' </' . esc_attr( $settings['gallery_title_type'] ) . '> ';
		}
	}
}
