<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Modula_Pro_Troubleshooting {
	public function __construct() {
		add_filter( 'modula_troubleshooting_fields', array( $this, 'add_troubleshooting_fields' ) );
		add_filter( 'modula_troubleshooting_defaults', array( $this, 'add_troubleshooting_defaults' ) );
		add_filter( 'modula_troubleshooting_frontend_handles', array( $this, 'add_main_pro_files' ), 60, 2 );
		add_filter( 'modula_troubleshooting_frontend_handles', array( $this, 'check_hovereffect' ), 20, 2 );
		add_filter( 'modula_troubleshooting_frontend_handles', array( $this, 'check_linkshortcode' ), 20, 2 );
	}

	public function add_troubleshooting_fields( $fields ) {
		$fields['hover_effects'] = array(
			'label'       => esc_html__( 'Hover Effects', 'modula-pro' ),
			'description' => esc_html__( 'Check this if you\'re using hover effects with tilt effect', 'modula-pro' ),
			'type'        => 'toggle',
			'class'       => array( 'troubleshoot-subfield' ),
			'priority'    => 41,
		);

		$fields['link_shortcode'] = array(
			'label'       => esc_html__( 'Link Shortcode', 'modula-pro' ),
			'description' => esc_html__( 'Check this if you\'re using modula link ( [modula-link] ) shortcode', 'modula-pro' ),
			'type'        => 'toggle',
			'class'       => array( 'troubleshoot-subfield' ),
			'priority'    => 42,
		);
		// Add Extensions settings heading
		$fields['extensions_settings'] = array(
			'label'       => esc_html__( 'Extensions settings', 'modula-pro' ),
			'description' => '',
			'type'        => 'heading',
			'class'       => array(),
			'priority'    => 60,
		);
		// Setting to enable beta versions for the Modula PRO and premium extensions
		$fields['enable_beta'] = array(
			'label'       => esc_html__( 'Enable "Beta"', 'modula-pro' ),
			'description' => esc_html__( 'Check this if you want to download beta versions of Modula PRO & extensions in order to test what is coming up.', 'modula-pro' ),
			'type'        => 'toggle',
			'class'       => array(),
			'priority'    => 42,
		);

		return $fields;
	}

	public function add_troubleshooting_defaults( $defaults ) {
		$defaults['hover_effects']  = false;
		$defaults['link_shortcode'] = false;
		$defaults['enable_beta']    = false;

		return $defaults;
	}

	public function add_main_pro_files( $handles ) {

		// remove modula lite effects
		$lite_effects = array_search( 'modula-effects', $handles['styles'], true );
		if ( false !== $lite_effects ) {
			unset( $handles['styles'][ $lite_effects ] );
		}

		// add modula pro main files
		$handles['scripts'][] = 'modula-pro';
		$handles['styles'][]  = 'modula-pro-effects';
		$handles['styles'][]  = 'modula-pro-bnb';

		return $handles;
	}

	public function check_hovereffect( $handles, $options ) {

		if ( $options['hover_effects'] ) {
			$handles['scripts'][] = 'modula-pro-tilt';
		}

		return $handles;
	}

	public function check_linkshortcode( $handles, $options ) {

		if ( $options['link_shortcode'] ) {
			$handles['scripts'][] = 'modula-link-shortcode';
		}

		return $handles;
	}
}
