<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * @since      2.0.0
 */
class Modula_PRO {
	private $license = false;

	public function __construct() {
		add_action( 'init', array( $this, 'set_locale' ) );
		$this->license = self::check_for_license();

		$this->load_dependencies();

		new Modula_Pro_Scripts();
		Modula_Pro_Backwards_Compatibility::get_instance();
		$notices = new Modula_Pro_Notices();
		new Modula_Pro_Bnb_Type();
		new Modula_Pro_Settings();

		if ( is_admin() ) {
			new Modula_Pro_Addon();
			new Modula_Pro_License_Activator();
			// Load the PRO Smart Upsells
			if ( class_exists( 'WPChill_Upsells' ) ) {
				Modula_PRO_Upsells::get_instance(
					array(
						'shop_url' => MODULA_PRO_STORE_URL,
						'license'  => array(
							'key'    => 'modula_pro_license_key',
							'status' => 'modula_pro_license_status',
						),
						'slug'     => 'modula',
					)
				);
			}

			if ( $this->license ) {
				Modula_Pro_Importer::get_instance();
			}
		}

		// Check for LITE version of the plugin.
		if ( ! $this->check_for_lite() ) {
			is_admin() && $notices->display_lite_notice();

			return;
		}

		Wpchill_License_Checker::get_instance( 'modula', $this->get_license_checker_args() );

		new Modula_Pro_Link_Shortcode();
		new Modula_Pro_Gallery_Upgrade();
		new Modula_Pro_Plugin_Conflicts();
		new Modula_Pro_Lightbox_Enhancer();
		new Modula_Pro_Templates();
		new Modula_Pro_Gutenberg();

		if ( is_admin() ) {
			new Modula_Pro_Admin( $this->license );
			new Modula_Pro_Debug();
			new Modula_Pro_Uninstaller();
		}

		add_filter( 'modula_packages', array( $this, 'modula_pro_packages' ), 35, 1 );
	}

	/**
	 * Check if Modula Lite is Active
	 *
	 * @return bool
	 * @since 2.4.1
	 */
	private function check_for_lite() {
		$check = array(
			'installed' => Modula_Pro_Helper::check_plugin_is_installed( 'modula-best-grid-gallery' ),
			'active'    => Modula_Pro_Helper::check_plugin_is_active( 'modula-best-grid-gallery' ),
		);

		if ( $check['active'] ) {
			return true;
		}

		return false;
	}

	public static function check_for_license() {
		$license_status = get_option( 'modula_pro_license_status' );

		// If the option is false it means it is empty
		if ( ! $license_status ) {
			return null;
		}

		// There is no license or license is not valid anymore, so we get all packages
		if ( 'valid' !== $license_status->license ) {
			return false;
		}

		return true;
	}


	private function load_dependencies() {
		require_once MODULA_PRO_PATH . 'includes/modula-pro-helper-functions.php';

		if ( is_admin() ) {
			require_once MODULA_PRO_PATH . 'includes/admin/modula-pro-addon-ajax.php';
		}
	}

	public function set_locale() {
		load_plugin_textdomain( 'modula-pro', false, dirname( plugin_basename( MODULA_PRO_FILE ) ) . '/languages' );
	}

	private function get_license_checker_args() {
		$args = array(
			'plugin_slug'     => 'modula-best-grid-gallery',
			'plugin_nicename' => 'Modula',
			'store_url'       => MODULA_PRO_STORE_URL,
			'item_id'         => MODULA_PRO_STORE_ITEM_ID,
			'license'         => 'modula_pro_license_key',
			'license_status'  => 'modula_pro_license_status',
			'plugin_file'     => MODULA_PRO_FILE,
		);

		return $args;
	}

	public function modula_pro_packages( $packages ) {

		if ( ! $this->license ) {
			return $packages;
		}

		$packages['packages'] = 'upgradable_packages';

		// Transient doesn't exist so we make the call
		$url         = preg_replace( '/\?.*/', '', get_bloginfo( 'url' ) );
		$license_key = get_option( 'modula_pro_license_key' );
		$query_var   = 'get-upgrade?license=' . $license_key . '&url=' . $url;

		$packages['route'] = $query_var;

		return $packages;
	}
}
