<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @return array
 *
 * Return default active filter
 */
function modula_pro_current_active_filter() {
	$id       = get_the_ID();
	$settings = get_post_meta( $id, 'modula-settings', true );
	$filters  = isset( $settings['filters'] ) ? $settings['filters'] : false;

	$return = array(
		'All' => esc_html__( 'All', 'modula-pro' ),
	);

	if ( $filters ) {
		foreach ( $filters as $filter ) {
			$comma             = '&#44';
			$return[ $filter ] = esc_html( str_replace( $comma, ',', $filter ) );
		}
	}

	return $return;
}

function modula_pro_sanitize_color( $color ) {

	if ( method_exists( 'Modula_Helper', 'sanitize_rgba_colour' ) ) {
		return Modula_Helper::sanitize_rgba_colour( $color );
	}

	if ( empty( $color ) || is_array( $color ) ) {
		return 'rgba(0,0,0,0)';
	}

	if ( false === strpos( $color, 'rgba' ) ) {
		return sanitize_hex_color( $color );
	}

	$color = str_replace( ' ', '', $color );
	sscanf( $color, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha );

	return 'rgba(' . absint( $red ) . ',' . absint( $green ) . ',' . absint( $blue ) . ',' . floatval( $alpha ) . ')';
}

function modula_pro_hex_to_rgb( $hex, $alpha = false ) {

	$hex = str_replace( '#', '', $hex );

	$length   = strlen( $hex );
	$rgb['r'] = hexdec( 6 === $length ? substr( $hex, 0, 2 ) : ( 3 === $length ? str_repeat( substr( $hex, 0, 1 ), 2 ) : 0 ) );
	$rgb['g'] = hexdec( 6 === $length ? substr( $hex, 2, 2 ) : ( 3 === $length ? str_repeat( substr( $hex, 1, 1 ), 2 ) : 0 ) );
	$rgb['b'] = hexdec( 6 === $length ? substr( $hex, 4, 2 ) : ( 3 === $length ? str_repeat( substr( $hex, 2, 1 ), 2 ) : 0 ) );
	if ( $alpha ) {
		$rgb['a'] = ( 0 < $alpha ) ? $alpha / 100 : 0;
	} else {
		$rgb['a'] = 1;
	}

	return 'rgba(' . absint( $rgb['r'] ) . ',' . absint( $rgb['g'] ) . ',' . absint( $rgb['b'] ) . ',' . floatval( $rgb['a'] ) . ')';
}
