<?php

class Modula_Pro_Updater {

	public function __construct() {
		add_action( 'init', array( $this, 'plugin_updater' ), 20 );
	}

	public function plugin_updater() {

		if ( ! class_exists( 'Modula_Pro_Base_Updater' ) ) {
			return;
		}

		// retrieve our license key from the DB
		$license_key = trim( get_option( 'modula_pro_license_key' ) );

		// setup the updater
		new Modula_Pro_Base_Updater(
			MODULA_PRO_STORE_URL,
			MODULA_PRO_FILE,
			array(
				'version' => MODULA_PRO_VERSION,          // current version number
				'license' => $license_key,               // license key (used get_option above to retrieve from DB)
				'item_id' => MODULA_PRO_STORE_ITEM_ID,       // ID of the product
				'author'  => 'WPChill',            // author of this plugin
				'beta'    => false,
			)
		);

		do_action( 'modula_pro_updater', $license_key, MODULA_PRO_STORE_URL );
	}
}
