<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\HEADING;
use \Elementor\Repeater;

/**
 * 
 * Image Widget .
 *
 */
class Travolo_Hero_Five extends Widget_Base {

	public function get_name() {
		return 'travoloherofive';
	}

	public function get_title() {
		return __('Hero Home Five', 'travolo');
	}


	public function get_icon() {
		return 'eicon-code';
	}


	public function get_categories() {
		return ['travolo'];
	}


	protected function register_controls() {
		//Top Content
		$this->start_controls_section(
			'slider_content',
			[
				'label' 	=> __('Slider Content', 'travolo'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label'     => __('Background Image', 'travolo'),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label'         => __('Sub Title', 'travolo'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('inspires', 'travolo'),
				'label_block'   => true,
			]
		);

		$this->add_control(
			'title',
			[
				'label'         => __('Title', 'travolo'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('Skin Refresh', 'travolo'),
				'label_block'   => true,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			[
				'label'     => __('Image', 'travolo'),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'herotwo_slides',
			[
				'label' 		=> __('Sliders', 'travolo'),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'image' 	  => Utils::get_placeholder_image_src(),

					],
					[
						'image' 	  => Utils::get_placeholder_image_src(),

					],
					[
						'image' 	  => Utils::get_placeholder_image_src(),

					],
				],
			]
		);

		$this->end_controls_section();


		//Button  Style
		$this->start_controls_section(
			'slider_settings',
			[
				'label' 	=> __('Slider Settings', 'travolo'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __('Autoplay', 'travolo'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'travolo'),
				'label_off' 	=> __('No', 'travolo'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __('Content Style', 'travolo'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' 	=> __('Color', 'travolo'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typo',
				'label' 	=> __('Title Typo', 'travolo'),
				'selector' 	=> '{{WRAPPER}} .hero-title',
			]
		);


		$this->add_responsive_control(
			'section_tile_padding',
			[
				'label' 		=> __('Padding', 'travolo'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_control(
			'sub_h_title',
			[
				'label' => esc_html__('Sub Title', 'travolo'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' 	=> __('Color', 'travolo'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-subtitle' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'sub_typo',
				'label' 	=> __('Typography', 'travolo'),
				'selector' 	=> '{{WRAPPER}} .hero-subtitle',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button_style',
			[
				'label' 	=> __('Button', 'travolo'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' 	=> __('Color', 'travolo'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn.style5' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg_color',
			[
				'label' 	=> __('Background Color', 'travolo'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn.style5' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typo',
				'label' 	=> __('Button Typo', 'travolo'),
				'selector' 	=> '{{WRAPPER}} .vs-btn.style5',
			]
		);

		$this->add_control(
			'button_hover',
			[
				'label' => esc_html__('Button Hover', 'travolo'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'button_color_active',
			[
				'label' 	=> __('Color', 'travolo'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn.style5:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'button_bg_color_active',
			[
				'label' 	=> __('Background Color', 'travolo'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn.style5::before, {{WRAPPER}} .vs-btn.style5::after' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {


		$settings = $this->get_settings_for_display(); ?>

		<section class="hero-layout3" data-bg-src="<?php echo esc_url($settings['bg_image']['url']);?>">
			<div class="hero-mask">
				<div class="container">
					<div class="row align-items-center justify-content-start">
						<div class="col-lg-10">
							<div class="row">
								<div class="col-lg-7">
									<div class="hero-content">
										<?php if ($settings['sub_title']) : ?>
											<span class="hero-subtitle"><?php echo wp_kses_post($settings['sub_title']); ?></span>
										<?php endif; ?>
										<?php if ($settings['title']) : ?>
											<h1 class="hero-title"><?php echo wp_kses_post($settings['title']); ?></h1>
										<?php endif; ?>
									</div>
								</div>
								<div class="col-lg-5">
									<div class="vs-carousel" id="hero-slider" data-slide-show="1" autoplay="false">
										<?php foreach ($settings['herotwo_slides'] as $slides) : ?>
											<div class="hero-slide">
												<div class="hero-img">
													<?php echo travolo_img_tag(array(
														'url'	=> esc_url($slides['image']['url']),
														'class'   => 'img1',
													));
													?>
												</div>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
<?php }
}
$widgets_manager->register(new \Travolo_Hero_Five());
