<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

/**
 *
 * Image Widget .
 *
 */
class Travolo_FAQ extends Widget_Base {

	public function get_name() {
		return 'travolofaq';
	}

	public function get_title() {
		return __('FAQ', 'travolo');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['travolo'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label' 	=> __('Content', 'travolo'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'faq_layout',
			[
				'label' => __('Style', 'travolo'),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => __('Style 1', 'travolo'),
				],
			]
		);


		$repeater = new Repeater();

		$repeater->add_control(
			'question',
			[
				'label' 	=> __('Question', 'travolo'),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'  	=> __('Help parents get to work on time?', 'travolo'),
			]
		);
		$repeater->add_control(
			'answer',
			[
				'label' 	=> __('Answer', 'travolo'),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'  	=> __('Bring To The Table Win-Win Survival Strategies To Ensure Proactive', 'travolo'),
			]
		);
		$this->add_control(
			'faq_items',
			[
				'label' 		=> __('FAQ List', 'travolo'),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'question'    => __('How Much Luggage Can I Bring?', 'travolo'),
					]
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'mdeia_style_option',
			[
				'label' 	=> __('Style', 'travolo'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __('Color', 'travolo'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-text' => 'color: {{VALUE}} !important',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'subtitle_typography',
				'label'         => __('Typography', 'travolo'),
				'selector'      => '{{WRAPPER}} .features-style1 .feature-text, {{WRAPPER}} .features-style2 .feature-text, {{WRAPPER}} .features-style3 .feature-text, {{WRAPPER}} .features-style4 .feature-text',
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		$faq_layout = $settings['faq_layout'];
?>

		<?php
		if ('1' == $settings['faq_layout']) : ?>
			<div class="accordion accordion-style1" id="faqVersion1">
				<?php foreach ($settings['faq_items'] as $index => $list) : ?>
					<div class="accordion-item">
						<div class="accordion-header" id="headingOne-<?php echo esc_attr($index); ?>">
							<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne-<?php echo esc_attr($index); ?>" aria-expanded="true" aria-controls="collapseOne-<?php echo esc_attr($index); ?>"><?php echo esc_html($list['question']); ?></button>
						</div>
						<div id="collapseOne-<?php echo esc_attr($index); ?>" class="accordion-collapse collapse <?php echo $index == '0' ? 'show' : ''; ?> " aria-labelledby="headingOne-<?php echo esc_attr($index); ?>" data-bs-parent="#faqVersion1">
							<div class="accordion-body">
								<p><?php echo wp_kses_post($list['answer']) ?></p>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>
<?php
	}
}
$widgets_manager->register(new \Travolo_FAQ());
