<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;

/**
 *
 * Trip Slider Widget .
 *
 */
class Travolo_trip_slider extends Widget_Base {

    public function get_name() {
        return 'travolotripsliders';
    }

    public function get_title() {
        return __('Trip Slider', 'travolo');
    }

    public function get_icon() {
        return 'eicon-code';
    }

    public function get_categories() {
        return ['travolo'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'trip_slider_section',
            [
                'label'     => __('Trip Slider', 'travolo'),
                'tab'         => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'trip_style',
            [
                'label'         => __('Trip Style', 'travolo'),
                'type'             => Controls_Manager::SELECT,
                'default'         => '1',
                'options'         => [
                    '1'              => __('Style One', 'travolo'),
                    '2'             => __('Style Two', 'travolo'),
                    '3'             => __('Style Three', 'travolo'),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label'         => __('Title', 'travolo'),
                'type'             => Controls_Manager::TEXTAREA,
                'default'         => __('Thailand', 'travolo'),
                'label_block'     => true,
            ]
        );
        $repeater->add_control(
            'price',
            [
                'label'         => __('Price', 'travolo'),
                'type'             => Controls_Manager::TEXT,
                'default'         => __('$270', 'travolo'),
                'label_block'     => true,
            ]
        );
        $repeater->add_control(
            'info',
            [
                'label'         => __('Information', 'travolo'),
                'type'             => Controls_Manager::TEXTAREA,
                'default'         => __('Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock', 'travolo'),
                'label_block'     => true,
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label'     => __('Button Text', 'travolo'),
                'type'         => Controls_Manager::TEXT,
                'dynamic'         => ['active'         => true],
                'default'      => __('Discover More', 'travolo')
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label'         => __('Link', 'travolo'),
                'type'             => Controls_Manager::URL,
                'dynamic'         => ['active'         => true],
                'placeholder'     => __('https://your-link.com', 'travolo'),
                'show_external' => true,
                'default'         => [
                    'url'             => '#',
                    'is_external'     => false,
                    'nofollow'         => false,
                ],
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label'         => __('Image', 'travolo'),
                'type'             => Controls_Manager::MEDIA,
                'default'         => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'slides',
            [
                'label'         => __('Slides', 'travolo'),
                'type'             => Controls_Manager::REPEATER,
                'fields'         => $repeater->get_controls(),
                'default'         => [
                    [
                        'title'         => __('Thailand', 'travolo'),

                    ],
                    [
                        'title'         => __('Thailand', 'travolo'),
                    ],
                ],
                'title_field'     => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'trip_slider_client_name_style_section',
            [
                'label'     => __('Trip Title', 'travolo'),
                'tab'         => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'trip_slider_client_name_color',
            [
                'label'         => __('Trip Title Color', 'travolo'),
                'type'             => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .destination-style3 .destination-name > a' => 'color: {{VALUE}}!important',
                ],
            ]
        );
        $this->add_control(
            'trip_slider_client_name_hover_color',
            [
                'label'         => __('Trip Title Hover Color', 'travolo'),
                'type'             => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .destination-style3 .destination-name > a:hover' => 'color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'         => 'trip_slider_client_name_typography',
                'label'     => __('Trip Title Typography', 'travolo'),
                'selector'     => '{{WRAPPER}} .destination-style3 .destination-name > a',
            ]
        );

        $this->add_responsive_control(
            'trip_slider_client_name_margin',
            [
                'label'         => __('Trip Title Margin', 'travolo'),
                'type'             => Controls_Manager::DIMENSIONS,
                'size_units'     => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .destination-style3 .destination-name > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'trip_slider_client_name_padding',
            [
                'label'         => __('Trip Title Padding', 'travolo'),
                'type'             => Controls_Manager::DIMENSIONS,
                'size_units'     => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .destination-style3 .destination-name > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'trip_slider_client_feedback_style_section',
            [
                'label'     => __('Trip Info', 'travolo'),
                'tab'         => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'trip_slider_client_feedback_color',
            [
                'label'     => __('Trip Info Color', 'travolo'),
                'type'         => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .destination-style3 .destination-text' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'         => 'trip_slider_client_feedback_typography',
                'label'     => __('Trip Info Typography', 'travolo'),
                'selector'     => '{{WRAPPER}} .destination-style3 .destination-text',
            ]
        );

        $this->add_responsive_control(
            'trip_slider_client_feedback_margin',
            [
                'label'         => __('Trip Info Margin', 'travolo'),
                'type'             => Controls_Manager::DIMENSIONS,
                'size_units'     => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .destination-style3 .destination-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'trip_slider_client_feedback_padding',
            [
                'label'         => __('Trip Info Padding', 'travolo'),
                'type'             => Controls_Manager::DIMENSIONS,
                'size_units'     => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .destination-style3 .destination-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'trip_slider_price_style_section',
            [
                'label'     => __('Trip Price', 'travolo'),
                'tab'         => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'trip_slider_price_color',
            [
                'label'     => __('Trip Price Color', 'travolo'),
                'type'         => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .destination-style3 .destination-price' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'         => 'trip_slider_price_typography',
                'label'     => __('Trip Price Typography', 'travolo'),
                'selector'     => '{{WRAPPER}} .destination-style3 .destination-price',
            ]
        );

        $this->add_responsive_control(
            'trip_slider_price_margin',
            [
                'label'         => __('Trip Price Margin', 'travolo'),
                'type'             => Controls_Manager::DIMENSIONS,
                'size_units'     => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .destination-style3 .destination-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'trip_slider_price_padding',
            [
                'label'         => __('Trip Price Padding', 'travolo'),
                'type'             => Controls_Manager::DIMENSIONS,
                'size_units'     => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .destination-style3 .destination-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();
    }
    protected function render() {

        $settings = $this->get_settings_for_display();
?>
        <div class="space-bottom destiniation-layout1">
            <div class="destination-list row vs-carousel" data-slide-show="5" data-arrows="false" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-center-mode="true" data-dots="true">
                <?php foreach ($settings['slides'] as $slide) :
                ?>

                    <div class="col-auto px-0">
                        <div class="destination-style3" data-bg-src="<?php echo esc_url($slide['image']['url']) ?>">
                            <div class="destination-info">
                                <?php if (!empty($slide['title'])) : ?>
                                    <h4 class="destination-name"><a href="<?php echo esc_url($slide['link']['url']) ?>"><?php echo wp_kses_post($slide['title']); ?></a></h4>
                                <?php endif; ?>
                                <?php if (!empty($slide['info'])) : ?>
                                    <p class="destination-text"><?php echo wp_kses_post($slide['info']); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($slide['price'])) : ?>
                                    <span class="destination-price"><?php echo esc_html($slide['price']); ?></span>
                                <?php endif; ?>
                                <div>
                                    <a href="<?php echo esc_url($slide['link']['url']) ?>" class="vs-btn style5"><?php ?><?php echo esc_html($slide['button_text']); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
<?php
    }
}
$widgets_manager->register(new \Travolo_trip_slider());
