<?php
/*
 * Currencies.
 *
 * @package WPTravelEngine/Constants
 * @since 6.0.0
 */

namespace WPTravelEngine\Helpers;

/**
 * Class Currencies
 * Constants for currencies.
 *
 * @since 6.0.0
 */
class Currencies {

	/**
	 * List of currencies.
	 *
	 * @return array
	 */
	public static function list(): array {
		return array(
			'AED' => __( 'United Arab Emirates dirham', 'wp-travel-engine' ),
			'AFN' => __( 'Afghan afghani', 'wp-travel-engine' ),
			'ALL' => __( 'Albanian lek', 'wp-travel-engine' ),
			'AMD' => __( 'Armenian dram', 'wp-travel-engine' ),
			'ANG' => __( 'Netherlands Antillean guilder', 'wp-travel-engine' ),
			'AOA' => __( 'Angolan kwanza', 'wp-travel-engine' ),
			'ARS' => __( 'Argentine peso', 'wp-travel-engine' ),
			'AUD' => __( 'Australian dollar', 'wp-travel-engine' ),
			'AWG' => __( 'Aruban florin', 'wp-travel-engine' ),
			'AZN' => __( 'Azerbaijani manat', 'wp-travel-engine' ),
			'BAM' => __( 'Bosnia and Herzegovina convertible mark', 'wp-travel-engine' ),
			'BBD' => __( 'Barbadian dollar', 'wp-travel-engine' ),
			'BDT' => __( 'Bangladeshi taka', 'wp-travel-engine' ),
			'BGN' => __( 'Bulgarian lev', 'wp-travel-engine' ),
			'BHD' => __( 'Bahraini dinar', 'wp-travel-engine' ),
			'BIF' => __( 'Burundian franc', 'wp-travel-engine' ),
			'BMD' => __( 'Bermudian dollar', 'wp-travel-engine' ),
			'BND' => __( 'Brunei dollar', 'wp-travel-engine' ),
			'BOB' => __( 'Bolivian boliviano', 'wp-travel-engine' ),
			'BRL' => __( 'Brazilian real', 'wp-travel-engine' ),
			'BSD' => __( 'Bahamian dollar', 'wp-travel-engine' ),
			'BTC' => __( 'Bitcoin', 'wp-travel-engine' ),
			'BTN' => __( 'Bhutanese ngultrum', 'wp-travel-engine' ),
			'BWP' => __( 'Botswana pula', 'wp-travel-engine' ),
			'BYR' => __( 'Belarusian ruble (old)', 'wp-travel-engine' ),
			'BYN' => __( 'Belarusian ruble', 'wp-travel-engine' ),
			'BZD' => __( 'Belize dollar', 'wp-travel-engine' ),
			'CAD' => __( 'Canadian dollar', 'wp-travel-engine' ),
			'CDF' => __( 'Congolese franc', 'wp-travel-engine' ),
			'CHF' => __( 'Swiss franc', 'wp-travel-engine' ),
			'CLP' => __( 'Chilean peso', 'wp-travel-engine' ),
			'CNY' => __( 'Chinese yuan', 'wp-travel-engine' ),
			'COP' => __( 'Colombian peso', 'wp-travel-engine' ),
			'CRC' => __( 'Costa Rican col&oacute;n', 'wp-travel-engine' ),
			'CUC' => __( 'Cuban convertible peso', 'wp-travel-engine' ),
			'CUP' => __( 'Cuban peso', 'wp-travel-engine' ),
			'CVE' => __( 'Cape Verdean escudo', 'wp-travel-engine' ),
			'CZK' => __( 'Czech koruna', 'wp-travel-engine' ),
			'DJF' => __( 'Djiboutian franc', 'wp-travel-engine' ),
			'DKK' => __( 'Danish krone', 'wp-travel-engine' ),
			'DOP' => __( 'Dominican peso', 'wp-travel-engine' ),
			'DZD' => __( 'Algerian dinar', 'wp-travel-engine' ),
			'EGP' => __( 'Egyptian pound', 'wp-travel-engine' ),
			'ERN' => __( 'Eritrean nakfa', 'wp-travel-engine' ),
			'ETB' => __( 'Ethiopian birr', 'wp-travel-engine' ),
			'EUR' => __( 'Euro', 'wp-travel-engine' ),
			'FJD' => __( 'Fijian dollar', 'wp-travel-engine' ),
			'FKP' => __( 'Falkland Islands pound', 'wp-travel-engine' ),
			'GBP' => __( 'Pound sterling', 'wp-travel-engine' ),
			'GEL' => __( 'Georgian lari', 'wp-travel-engine' ),
			'GGP' => __( 'Guernsey pound', 'wp-travel-engine' ),
			'GHS' => __( 'Ghana cedi', 'wp-travel-engine' ),
			'GIP' => __( 'Gibraltar pound', 'wp-travel-engine' ),
			'GMD' => __( 'Gambian dalasi', 'wp-travel-engine' ),
			'GNF' => __( 'Guinean franc', 'wp-travel-engine' ),
			'GTQ' => __( 'Guatemalan quetzal', 'wp-travel-engine' ),
			'GYD' => __( 'Guyanese dollar', 'wp-travel-engine' ),
			'HKD' => __( 'Hong Kong dollar', 'wp-travel-engine' ),
			'HNL' => __( 'Honduran lempira', 'wp-travel-engine' ),
			'HRK' => __( 'Croatian kuna', 'wp-travel-engine' ),
			'HTG' => __( 'Haitian gourde', 'wp-travel-engine' ),
			'HUF' => __( 'Hungarian forint', 'wp-travel-engine' ),
			'IDR' => __( 'Indonesian rupiah', 'wp-travel-engine' ),
			'ILS' => __( 'Israeli new shekel', 'wp-travel-engine' ),
			'IMP' => __( 'Manx pound', 'wp-travel-engine' ),
			'INR' => __( 'Indian rupee', 'wp-travel-engine' ),
			'IQD' => __( 'Iraqi dinar', 'wp-travel-engine' ),
			'IRR' => __( 'Iranian rial', 'wp-travel-engine' ),
			'IRT' => __( 'Iranian toman', 'wp-travel-engine' ),
			'ISK' => __( 'Icelandic kr&oacute;na', 'wp-travel-engine' ),
			'JEP' => __( 'Jersey pound', 'wp-travel-engine' ),
			'JMD' => __( 'Jamaican dollar', 'wp-travel-engine' ),
			'JOD' => __( 'Jordanian dinar', 'wp-travel-engine' ),
			'JPY' => __( 'Japanese yen', 'wp-travel-engine' ),
			'KES' => __( 'Kenyan shilling', 'wp-travel-engine' ),
			'KGS' => __( 'Kyrgyzstani som', 'wp-travel-engine' ),
			'KHR' => __( 'Cambodian riel', 'wp-travel-engine' ),
			'KMF' => __( 'Comorian franc', 'wp-travel-engine' ),
			'KPW' => __( 'North Korean won', 'wp-travel-engine' ),
			'KRW' => __( 'South Korean won', 'wp-travel-engine' ),
			'KWD' => __( 'Kuwaiti dinar', 'wp-travel-engine' ),
			'KYD' => __( 'Cayman Islands dollar', 'wp-travel-engine' ),
			'KZT' => __( 'Kazakhstani tenge', 'wp-travel-engine' ),
			'LAK' => __( 'Lao kip', 'wp-travel-engine' ),
			'LBP' => __( 'Lebanese pound', 'wp-travel-engine' ),
			'LKR' => __( 'Sri Lankan rupee', 'wp-travel-engine' ),
			'LRD' => __( 'Liberian dollar', 'wp-travel-engine' ),
			'LSL' => __( 'Lesotho loti', 'wp-travel-engine' ),
			'LYD' => __( 'Libyan dinar', 'wp-travel-engine' ),
			'MAD' => __( 'Moroccan dirham', 'wp-travel-engine' ),
			'MDL' => __( 'Moldovan leu', 'wp-travel-engine' ),
			'MGA' => __( 'Malagasy ariary', 'wp-travel-engine' ),
			'MKD' => __( 'Macedonian denar', 'wp-travel-engine' ),
			'MMK' => __( 'Burmese kyat', 'wp-travel-engine' ),
			'MNT' => __( 'Mongolian t&ouml;gr&ouml;g', 'wp-travel-engine' ),
			'MOP' => __( 'Macanese pataca', 'wp-travel-engine' ),
			'MRO' => __( 'Mauritanian ouguiya', 'wp-travel-engine' ),
			'MUR' => __( 'Mauritian rupee', 'wp-travel-engine' ),
			'MVR' => __( 'Maldivian rufiyaa', 'wp-travel-engine' ),
			'MWK' => __( 'Malawian kwacha', 'wp-travel-engine' ),
			'MXN' => __( 'Mexican peso', 'wp-travel-engine' ),
			'MYR' => __( 'Malaysian ringgit', 'wp-travel-engine' ),
			'MZN' => __( 'Mozambican metical', 'wp-travel-engine' ),
			'NAD' => __( 'Namibian dollar', 'wp-travel-engine' ),
			'NGN' => __( 'Nigerian naira', 'wp-travel-engine' ),
			'NIO' => __( 'Nicaraguan c&oacute;rdoba', 'wp-travel-engine' ),
			'NOK' => __( 'Norwegian krone', 'wp-travel-engine' ),
			'NPR' => __( 'Nepalese rupee', 'wp-travel-engine' ),
			'NZD' => __( 'New Zealand dollar', 'wp-travel-engine' ),
			'OMR' => __( 'Omani rial', 'wp-travel-engine' ),
			'PAB' => __( 'Panamanian balboa', 'wp-travel-engine' ),
			'PEN' => __( 'Peruvian nuevo sol', 'wp-travel-engine' ),
			'PGK' => __( 'Papua New Guinean kina', 'wp-travel-engine' ),
			'PHP' => __( 'Philippine peso', 'wp-travel-engine' ),
			'PKR' => __( 'Pakistani rupee', 'wp-travel-engine' ),
			'PLN' => __( 'Polish z&#x142;oty', 'wp-travel-engine' ),
			'PRB' => __( 'Transnistrian ruble', 'wp-travel-engine' ),
			'PYG' => __( 'Paraguayan guaran&iacute;', 'wp-travel-engine' ),
			'QAR' => __( 'Qatari riyal', 'wp-travel-engine' ),
			'RON' => __( 'Romanian leu', 'wp-travel-engine' ),
			'RSD' => __( 'Serbian dinar', 'wp-travel-engine' ),
			'RUB' => __( 'Russian ruble', 'wp-travel-engine' ),
			'RWF' => __( 'Rwandan franc', 'wp-travel-engine' ),
			'SAR' => __( 'Saudi riyal', 'wp-travel-engine' ),
			'SBD' => __( 'Solomon Islands dollar', 'wp-travel-engine' ),
			'SCR' => __( 'Seychellois rupee', 'wp-travel-engine' ),
			'SDG' => __( 'Sudanese pound', 'wp-travel-engine' ),
			'SEK' => __( 'Swedish krona', 'wp-travel-engine' ),
			'SGD' => __( 'Singapore dollar', 'wp-travel-engine' ),
			'SHP' => __( 'Saint Helena pound', 'wp-travel-engine' ),
			'SLL' => __( 'Sierra Leonean leone', 'wp-travel-engine' ),
			'SOS' => __( 'Somali shilling', 'wp-travel-engine' ),
			'SRD' => __( 'Surinamese dollar', 'wp-travel-engine' ),
			'SSP' => __( 'South Sudanese pound', 'wp-travel-engine' ),
			'STD' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'wp-travel-engine' ),
			'SYP' => __( 'Syrian pound', 'wp-travel-engine' ),
			'SZL' => __( 'Swazi lilangeni', 'wp-travel-engine' ),
			'THB' => __( 'Thai baht', 'wp-travel-engine' ),
			'TJS' => __( 'Tajikistani somoni', 'wp-travel-engine' ),
			'TMT' => __( 'Turkmenistan manat', 'wp-travel-engine' ),
			'TND' => __( 'Tunisian dinar', 'wp-travel-engine' ),
			'TOP' => __( 'Tongan pa&#x2bb;anga', 'wp-travel-engine' ),
			'TRY' => __( 'Turkish lira', 'wp-travel-engine' ),
			'TTD' => __( 'Trinidad and Tobago dollar', 'wp-travel-engine' ),
			'TWD' => __( 'New Taiwan dollar', 'wp-travel-engine' ),
			'TZS' => __( 'Tanzanian shilling', 'wp-travel-engine' ),
			'UAH' => __( 'Ukrainian hryvnia', 'wp-travel-engine' ),
			'UGX' => __( 'Ugandan shilling', 'wp-travel-engine' ),
			'USD' => __( 'United States (US) dollar', 'wp-travel-engine' ),
			'UYU' => __( 'Uruguayan peso', 'wp-travel-engine' ),
			'UZS' => __( 'Uzbekistani som', 'wp-travel-engine' ),
			'VEF' => __( 'Venezuelan bol&iacute;var', 'wp-travel-engine' ),
			'VND' => __( 'Vietnamese &#x111;&#x1ed3;ng', 'wp-travel-engine' ),
			'VUV' => __( 'Vanuatu vatu', 'wp-travel-engine' ),
			'WST' => __( 'Samoan t&#x101;l&#x101;', 'wp-travel-engine' ),
			'XAF' => __( 'Central African CFA franc', 'wp-travel-engine' ),
			'XCD' => __( 'East Caribbean dollar', 'wp-travel-engine' ),
			'XOF' => __( 'West African CFA franc', 'wp-travel-engine' ),
			'XPF' => __( 'CFP franc', 'wp-travel-engine' ),
			'YER' => __( 'Yemeni rial', 'wp-travel-engine' ),
			'ZAR' => __( 'South African rand', 'wp-travel-engine' ),
			'ZMW' => __( 'Zambian kwacha', 'wp-travel-engine' ),
		);
	}

	/**
	 * Get currency code-symbol pair list.
	 *
	 * @return array
	 */
	public static function code_symbols(): array {
		return array(
			'AED' => '&#x62f;.&#x625;',
			'AFN' => '&#x60b;',
			'ALL' => 'L',
			'AMD' => 'AMD',
			'ANG' => '&fnof;',
			'AOA' => 'Kz',
			'ARS' => '&#36;',
			'AUD' => '&#36;',
			'AWG' => 'Afl.',
			'AZN' => 'AZN',
			'BAM' => 'KM',
			'BBD' => '&#36;',
			'BDT' => '&#2547;&nbsp;',
			'BGN' => '&#1083;&#1074;.',
			'BHD' => '.&#x62f;.&#x628;',
			'BIF' => 'Fr',
			'BMD' => '&#36;',
			'BND' => '&#36;',
			'BOB' => 'Bs.',
			'BRL' => '&#82;&#36;',
			'BSD' => '&#36;',
			'BTC' => '&#3647;',
			'BTN' => 'Nu.',
			'BWP' => 'P',
			'BYR' => 'Br',
			'BYN' => 'Br',
			'BZD' => '&#36;',
			'CAD' => '&#36;',
			'CDF' => 'Fr',
			'CHF' => '&#67;&#72;&#70;',
			'CLP' => '&#36;',
			'CNY' => '&yen;',
			'COP' => '&#36;',
			'CRC' => '&#x20a1;',
			'CUC' => '&#36;',
			'CUP' => '&#36;',
			'CVE' => '&#36;',
			'CZK' => '&#75;&#269;',
			'DJF' => 'Fr',
			'DKK' => 'DKK',
			'DOP' => 'RD&#36;',
			'DZD' => '&#x62f;.&#x62c;',
			'EGP' => 'EGP',
			'ERN' => 'Nfk',
			'ETB' => 'Br',
			'EUR' => '&euro;',
			'FJD' => '&#36;',
			'FKP' => '&pound;',
			'GBP' => '&pound;',
			'GEL' => '&#x20be;',
			'GGP' => '&pound;',
			'GHS' => '&#x20b5;',
			'GIP' => '&pound;',
			'GMD' => 'D',
			'GNF' => 'Fr',
			'GTQ' => 'Q',
			'GYD' => '&#36;',
			'HKD' => '&#36;',
			'HNL' => 'L',
			'HRK' => 'kn',
			'HTG' => 'G',
			'HUF' => '&#70;&#116;',
			'IDR' => 'Rp',
			'ILS' => '&#8362;',
			'IMP' => '&pound;',
			'INR' => '&#8377;',
			'IQD' => '&#x639;.&#x62f;',
			'IRR' => '&#xfdfc;',
			'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
			'ISK' => 'kr.',
			'JEP' => '&pound;',
			'JMD' => '&#36;',
			'JOD' => '&#x62f;.&#x627;',
			'JPY' => '&yen;',
			'KES' => 'KSh',
			'KGS' => '&#x441;&#x43e;&#x43c;',
			'KHR' => '&#x17db;',
			'KMF' => 'Fr',
			'KPW' => '&#x20a9;',
			'KRW' => '&#8361;',
			'KWD' => '&#x62f;.&#x643;',
			'KYD' => '&#36;',
			'KZT' => 'KZT',
			'LAK' => '&#8365;',
			'LBP' => '&#x644;.&#x644;',
			'LKR' => '&#xdbb;&#xdd4;',
			'LRD' => '&#36;',
			'LSL' => 'L',
			'LYD' => '&#x644;.&#x62f;',
			'MAD' => '&#x62f;.&#x645;.',
			'MDL' => 'MDL',
			'MGA' => 'Ar',
			'MKD' => '&#x434;&#x435;&#x43d;',
			'MMK' => 'Ks',
			'MNT' => '&#x20ae;',
			'MOP' => 'P',
			'MRO' => 'UM',
			'MUR' => '&#x20a8;',
			'MVR' => '.&#x783;',
			'MWK' => 'MK',
			'MXN' => '&#36;',
			'MYR' => '&#82;&#77;',
			'MZN' => 'MT',
			'NAD' => '&#36;',
			'NGN' => '&#8358;',
			'NIO' => 'C&#36;',
			'NOK' => '&#107;&#114;',
			'NPR' => '&#8360;',
			'NZD' => '&#36;',
			'OMR' => '&#x631;.&#x639;.',
			'PAB' => 'B/.',
			'PEN' => 'S/.',
			'PGK' => 'K',
			'PHP' => '&#8369;',
			'PKR' => '&#8360;',
			'PLN' => '&#122;&#322;',
			'PRB' => '&#x440;.',
			'PYG' => '&#8370;',
			'QAR' => '&#x631;.&#x642;',
			'RMB' => '&yen;',
			'RON' => 'lei',
			'RSD' => '&#x434;&#x438;&#x43d;.',
			'RUB' => '&#8381;',
			'RWF' => 'Fr',
			'SAR' => '&#x631;.&#x633;',
			'SBD' => '&#36;',
			'SCR' => '&#x20a8;',
			'SDG' => '&#x62c;.&#x633;.',
			'SEK' => '&#107;&#114;',
			'SGD' => '&#36;',
			'SHP' => '&pound;',
			'SLL' => 'Le',
			'SOS' => 'Sh',
			'SRD' => '&#36;',
			'SSP' => '&pound;',
			'STD' => 'Db',
			'SYP' => '&#x644;.&#x633;',
			'SZL' => 'L',
			'THB' => '&#3647;',
			'TJS' => '&#x405;&#x41c;',
			'TMT' => 'm',
			'TND' => '&#x62f;.&#x62a;',
			'TOP' => 'T&#36;',
			'TRY' => '&#8378;',
			'TTD' => '&#36;',
			'TWD' => '&#78;&#84;&#36;',
			'TZS' => 'Sh',
			'UAH' => '&#8372;',
			'UGX' => 'UGX',
			'USD' => '&#36;',
			'UYU' => '&#36;',
			'UZS' => 'UZS',
			'VEF' => 'Bs F',
			'VND' => '&#8363;',
			'VUV' => 'Vt',
			'WST' => 'T',
			'XAF' => 'CFA',
			'XCD' => '&#36;',
			'XOF' => 'CFA',
			'XPF' => 'Fr',
			'YER' => '&#xfdfc;',
			'ZAR' => '&#82;',
			'ZMW' => 'ZK',
		);
	}
}
