(function (Modula) {
    "use strict";

    var modulaExifConditions = Backbone.Model.extend({
        initialize: function ( args ) {
            var rows = jQuery( ".modula-settings-container tr[data-container]" );
            var tabs = jQuery( ".modula-tabs .modula-tab" );
            this.set( "rows", rows );
            this.set( "tabs", tabs );

            this.initEvents();
            this.initValues();
        },

        initValues: function () {
            this.changedExif( false, wp.Modula.Settings.get( "enable_exif" ) );
        },

        initEvents: function () {
            this.listenTo(
                wp.Modula.Settings,
                "change:enable_exif",
                this.changedExif
            );
        },

        changedExif: function (settings, value) {

            var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_exif"]'),
            children  = currentRow.data( 'children' );

            jQuery.each(children, function(index, item) {

                var child = jQuery('[data-container="'+item+'"]');

                if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
                    child.setting_state( this, 'off');
                    child.show();
                }else if( 0 == value ){
                    child.hide();
                }else{
                    child.css('opacity', '1');
                    child.find('input, textarea, select, button').removeAttr('disabled');
                    child.show();
                }

            });

		if( 1 == value ) {
			currentRow.addClass( 'modula_accordion_open' );
		}
        },
    });

    jQuery(document).ready(function () {
        new modulaExifConditions();
    });
})(jQuery, wp.Modula);
